/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.AbstractQueryController;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartKeyValueCache;
import co.easimart.EasimartLog;
import co.easimart.EasimartObject;
import co.easimart.EasimartQuery;
import co.easimart.EasimartRESTQueryCommand;
import co.easimart.EasimartUser;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class NetworkQueryController
extends AbstractQueryController {
    private static final String TAG = "NetworkQueryController";
    private final EasimartHttpClient restClient;

    public NetworkQueryController(EasimartHttpClient restClient) {
        this.restClient = restClient;
    }

    @Override
    public <T extends EasimartObject> Task<List<T>> findAsync(EasimartQuery.State<T> state, EasimartUser user, Task<Void> cancellationToken) {
        String sessionToken = user != null ? user.getSessionToken() : null;
        return this.findAsync(state, sessionToken, true, cancellationToken);
    }

    @Override
    public <T extends EasimartObject> Task<Integer> countAsync(EasimartQuery.State<T> state, EasimartUser user, Task<Void> cancellationToken) {
        String sessionToken = user != null ? user.getSessionToken() : null;
        return this.countAsync(state, sessionToken, true, cancellationToken);
    }

    <T extends EasimartObject> Task<List<T>> findAsync(final EasimartQuery.State<T> state, String sessionToken, boolean shouldRetry, Task<Void> ct) {
        final long queryStart = System.nanoTime();
        final EasimartRESTQueryCommand command = EasimartRESTQueryCommand.findCommand(state, sessionToken);
        if (shouldRetry) {
            command.enableRetrying();
        }
        final long querySent = System.nanoTime();
        return command.executeAsync(this.restClient, ct).onSuccess(new Continuation<JSONObject, List<T>>(){

            public List<T> then(Task<JSONObject> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                EasimartQuery.CachePolicy policy = state.cachePolicy();
                if (policy != null && policy != EasimartQuery.CachePolicy.IGNORE_CACHE) {
                    EasimartKeyValueCache.saveToKeyValueCache(command.getCacheKey(), json.toString());
                }
                long queryReceived = System.nanoTime();
                List response = NetworkQueryController.this.convertFindResponse(state, (JSONObject)task.getResult());
                long objectsEasimartd = System.nanoTime();
                if (json.has("trace")) {
                    Object serverTrace = json.get("trace");
                    EasimartLog.d("EasimartQuery", String.format("Query pre-processing took %f seconds\n%s\nClient side parsing took %f seconds\n", Float.valueOf((float)(querySent - queryStart) / 1000000.0f), serverTrace, Float.valueOf((float)(objectsEasimartd - queryReceived) / 1000000.0f)));
                }
                return response;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    <T extends EasimartObject> Task<Integer> countAsync(final EasimartQuery.State<T> state, String sessionToken, boolean shouldRetry, Task<Void> ct) {
        final EasimartRESTQueryCommand command = EasimartRESTQueryCommand.countCommand(state, sessionToken);
        if (shouldRetry) {
            command.enableRetrying();
        }
        return command.executeAsync(this.restClient, ct).onSuccessTask((Continuation)new Continuation<JSONObject, Task<JSONObject>>(){

            public Task<JSONObject> then(Task<JSONObject> task) throws Exception {
                EasimartQuery.CachePolicy policy = state.cachePolicy();
                if (policy != null && policy != EasimartQuery.CachePolicy.IGNORE_CACHE) {
                    JSONObject result = (JSONObject)task.getResult();
                    EasimartKeyValueCache.saveToKeyValueCache(command.getCacheKey(), result.toString());
                }
                return task;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR).onSuccess((Continuation)new Continuation<JSONObject, Integer>(){

            public Integer then(Task<JSONObject> task) throws Exception {
                return ((JSONObject)task.getResult()).optInt("count");
            }
        });
    }

    <T extends EasimartObject> List<T> convertFindResponse(EasimartQuery.State<T> state, JSONObject response) throws JSONException {
        ArrayList answer = new ArrayList();
        JSONArray results = response.getJSONArray("results");
        if (results == null) {
            EasimartLog.d(TAG, "null results in find response");
        } else {
            String resultClassName = response.optString("className", null);
            if (resultClassName == null) {
                resultClassName = state.className();
            }
            for (int i = 0; i < results.length(); ++i) {
                JSONObject data = results.getJSONObject(i);
                Object object = EasimartObject.fromJSON(data, resultClassName, state.selectedKeys() == null);
                answer.add(object);
                EasimartQuery.RelationConstraint relation = (EasimartQuery.RelationConstraint)state.constraints().get("$relatedTo");
                if (relation == null) continue;
                relation.getRelation().addKnownObject((EasimartObject)object);
            }
        }
        return answer;
    }
}

