/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartObject;
import co.easimart.EasimartObjectCoder;
import co.easimart.EasimartOperationSet;
import co.easimart.EasimartRESTUserCommand;
import co.easimart.EasimartUser;
import co.easimart.EasimartUserController;
import co.easimart.PointerEncoder;
import java.util.Map;
import org.json.JSONObject;

class NetworkUserController
implements EasimartUserController {
    private static final int STATUS_CODE_CREATED = 201;
    private final EasimartHttpClient client;
    private final EasimartObjectCoder coder;
    private final boolean revocableSession;

    public NetworkUserController(EasimartHttpClient client) {
        this(client, false);
    }

    public NetworkUserController(EasimartHttpClient client, boolean revocableSession) {
        this.client = client;
        this.coder = EasimartObjectCoder.get();
        this.revocableSession = revocableSession;
    }

    @Override
    public Task<EasimartUser.State> signUpAsync(EasimartObject.State state, EasimartOperationSet operations, String sessionToken) {
        JSONObject objectJSON = this.coder.encode(state, operations, PointerEncoder.get());
        EasimartRESTUserCommand command = EasimartRESTUserCommand.signUpUserCommand(objectJSON, sessionToken, this.revocableSession);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, EasimartUser.State>(){

            public EasimartUser.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((EasimartUser.State.Builder)NetworkUserController.this.coder.decode(new EasimartUser.State.Builder(), result, EasimartDecoder.get()).isComplete(false)).isNew(true).build();
            }
        });
    }

    @Override
    public Task<EasimartUser.State> logInAsync(String username, String password) {
        EasimartRESTUserCommand command = EasimartRESTUserCommand.logInUserCommand(username, password, this.revocableSession);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, EasimartUser.State>(){

            public EasimartUser.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((EasimartUser.State.Builder)NetworkUserController.this.coder.decode(new EasimartUser.State.Builder(), result, EasimartDecoder.get()).isComplete(true)).build();
            }
        });
    }

    @Override
    public Task<EasimartUser.State> logInAsync(EasimartUser.State state, EasimartOperationSet operations) {
        JSONObject objectJSON = this.coder.encode(state, operations, PointerEncoder.get());
        final EasimartRESTUserCommand command = EasimartRESTUserCommand.serviceLogInUserCommand(objectJSON, state.sessionToken(), this.revocableSession);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, EasimartUser.State>(){

            public EasimartUser.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                boolean isNew = command.getStatusCode() == 201;
                boolean isComplete = !isNew;
                return ((EasimartUser.State.Builder)NetworkUserController.this.coder.decode(new EasimartUser.State.Builder(), result, EasimartDecoder.get()).isComplete(isComplete)).isNew(isNew).build();
            }
        });
    }

    @Override
    public Task<EasimartUser.State> logInAsync(final String authType, final Map<String, String> authData) {
        final EasimartRESTUserCommand command = EasimartRESTUserCommand.serviceLogInUserCommand(authType, authData, this.revocableSession);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, EasimartUser.State>(){

            public EasimartUser.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((EasimartUser.State.Builder)NetworkUserController.this.coder.decode(new EasimartUser.State.Builder(), result, EasimartDecoder.get()).isComplete(true)).isNew(command.getStatusCode() == 201).putAuthData(authType, authData).build();
            }
        });
    }

    @Override
    public Task<EasimartUser.State> getUserAsync(String sessionToken) {
        EasimartRESTUserCommand command = EasimartRESTUserCommand.getCurrentUserCommand(sessionToken);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, EasimartUser.State>(){

            public EasimartUser.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((EasimartUser.State.Builder)NetworkUserController.this.coder.decode(new EasimartUser.State.Builder(), result, EasimartDecoder.get()).isComplete(true)).build();
            }
        });
    }

    @Override
    public Task<Void> requestPasswordResetAsync(String email) {
        EasimartRESTUserCommand command = EasimartRESTUserCommand.resetPasswordResetCommand(email);
        return command.executeAsync(this.client).makeVoid();
    }
}

