/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Task;
import co.easimart.AbstractQueryController;
import co.easimart.EasimartObject;
import co.easimart.EasimartQuery;
import co.easimart.EasimartQueryController;
import co.easimart.EasimartUser;
import co.easimart.OfflineStore;
import java.util.List;

class OfflineQueryController
extends AbstractQueryController {
    private final OfflineStore offlineStore;
    private final EasimartQueryController networkController;

    public OfflineQueryController(OfflineStore store, EasimartQueryController network) {
        this.offlineStore = store;
        this.networkController = network;
    }

    @Override
    public <T extends EasimartObject> Task<List<T>> findAsync(EasimartQuery.State<T> state, EasimartUser user, Task<Void> cancellationToken) {
        if (state.isFromLocalDatastore()) {
            return this.offlineStore.findFromPinAsync(state.pinName(), state, user);
        }
        return this.networkController.findAsync(state, user, cancellationToken);
    }

    @Override
    public <T extends EasimartObject> Task<Integer> countAsync(EasimartQuery.State<T> state, EasimartUser user, Task<Void> cancellationToken) {
        if (state.isFromLocalDatastore()) {
            return this.offlineStore.countFromPinAsync(state.pinName(), state, user);
        }
        return this.networkController.countAsync(state, user, cancellationToken);
    }
}

