/*
 * Decompiled with CFR 0.152.
 */
package co.easimart.provider;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import co.easimart.provider.Artwork;
import co.easimart.provider.UserCommand;
import co.easimart.provider.internal.SourceState;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class ArtSource
extends Service {
    private static final String TAG = "ArtSource";
    public static final String ACTION_EASIMART_ART_SOURCE = "co.easimart.provider.ArtSource";
    public static final String EXTRA_FROM_EASIMART_SETTINGS = "co.easimart.provider.extra.FROM_EASIMART_SETTINGS";
    public static final String EXTRA_INITIAL_SETUP = "co.easimart.provider.extra.INITIAL_SETUP";
    private static final int FIRST_BUILTIN_COMMAND_ID = 1000;
    public static final int BUILTIN_COMMAND_ID_NEXT_ARTWORK = 1001;
    protected static final int MAX_CUSTOM_COMMAND_ID = 999;
    public static final int UPDATE_REASON_OTHER = 0;
    public static final int UPDATE_REASON_INITIAL = 1;
    public static final int UPDATE_REASON_USER_NEXT = 2;
    public static final int UPDATE_REASON_SCHEDULED = 3;
    private static final String PREF_STATE = "state";
    private static final String PREF_SUBSCRIPTIONS = "subscriptions";
    private static final String PREF_SCHEDULED_UPDATE_TIME_MILLIS = "scheduled_update_time_millis";
    private static final String URI_SCHEME_COMMAND = "easimartcommand";
    private SharedPreferences mSharedPrefs;
    private Map<ComponentName, String> mSubscriptions;
    private SourceState mCurrentState;
    private Runnable mPublishStateRunnable = new Runnable(){

        @Override
        public void run() {
            ArtSource.this.publishCurrentState();
            ArtSource.this.saveState();
        }
    };
    private String mName;
    private boolean mRedelivery;
    private volatile Looper mServiceLooper;
    private volatile ServiceHandler mServiceHandler;

    public ArtSource(String name) {
        this.mName = name;
    }

    public void onCreate() {
        super.onCreate();
        HandlerThread thread = new HandlerThread("IntentService[" + this.mName + "]");
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
        this.mSharedPrefs = this.getSharedPreferences();
        this.loadSubscriptions();
        this.loadState();
    }

    public void onStart(Intent intent, int startId) {
        Message msg = this.mServiceHandler.obtainMessage();
        msg.arg1 = startId;
        msg.obj = intent;
        this.mServiceHandler.sendMessage(msg);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.onStart(intent, startId);
        return this.mRedelivery ? 3 : 2;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mServiceLooper.quit();
    }

    public void setIntentRedelivery(boolean enabled) {
        this.mRedelivery = enabled;
    }

    protected boolean onAllowSubscription(ComponentName subscriber) {
        return true;
    }

    protected void onSubscriberAdded(ComponentName subscriber) {
    }

    protected void onSubscriberRemoved(ComponentName subscriber) {
    }

    protected void onEnabled() {
    }

    protected void onDisabled() {
    }

    protected abstract void onUpdate(int var1);

    protected void onCustomCommand(int id) {
    }

    protected void onNetworkAvailable() {
    }

    protected final void publishArtwork(Artwork artwork) {
        this.mCurrentState.setCurrentArtwork(artwork);
        this.mServiceHandler.removeCallbacks(this.mPublishStateRunnable);
        this.mServiceHandler.post(this.mPublishStateRunnable);
    }

    protected final void setDescription(String description) {
        this.mCurrentState.setDescription(description);
        this.mServiceHandler.removeCallbacks(this.mPublishStateRunnable);
        this.mServiceHandler.post(this.mPublishStateRunnable);
    }

    protected final void setUserCommands(UserCommand ... commands) {
        this.mCurrentState.setUserCommands(Arrays.asList(commands));
        this.mServiceHandler.removeCallbacks(this.mPublishStateRunnable);
        this.mServiceHandler.post(this.mPublishStateRunnable);
    }

    protected final void setUserCommands(List<UserCommand> commands) {
        this.mCurrentState.setUserCommands(commands);
        this.mServiceHandler.removeCallbacks(this.mPublishStateRunnable);
        this.mServiceHandler.post(this.mPublishStateRunnable);
    }

    protected final void setUserCommands(int ... commands) {
        this.mCurrentState.setUserCommands(commands);
        this.mServiceHandler.removeCallbacks(this.mPublishStateRunnable);
        this.mServiceHandler.post(this.mPublishStateRunnable);
    }

    protected final void removeAllUserCommands() {
        this.mCurrentState.setUserCommands((int[])null);
        this.mServiceHandler.removeCallbacks(this.mPublishStateRunnable);
        this.mServiceHandler.post(this.mPublishStateRunnable);
    }

    protected final void setWantsNetworkAvailable(boolean wantsNetworkAvailable) {
        this.mCurrentState.setWantsNetworkAvailable(wantsNetworkAvailable);
        this.mServiceHandler.removeCallbacks(this.mPublishStateRunnable);
        this.mServiceHandler.post(this.mPublishStateRunnable);
    }

    protected final Artwork getCurrentArtwork() {
        return this.mCurrentState != null ? this.mCurrentState.getCurrentArtwork() : null;
    }

    protected final void scheduleUpdate(long scheduledUpdateTimeMillis) {
        this.getSharedPreferences().edit().putLong(PREF_SCHEDULED_UPDATE_TIME_MILLIS, scheduledUpdateTimeMillis).commit();
        this.setUpdateAlarm(scheduledUpdateTimeMillis);
    }

    protected final void unscheduleUpdate() {
        this.getSharedPreferences().edit().remove(PREF_SCHEDULED_UPDATE_TIME_MILLIS).apply();
        this.clearUpdateAlarm();
    }

    protected final synchronized boolean isEnabled() {
        return this.mSubscriptions.size() > 0;
    }

    protected static SharedPreferences getSharedPreferences(Context context, String sourceName) {
        return context.getSharedPreferences("easimartartsource_" + sourceName, 0);
    }

    protected final SharedPreferences getSharedPreferences() {
        return ArtSource.getSharedPreferences((Context)this, this.mName);
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if ("co.easimart.api.action.SUBSCRIBE".equals(action)) {
            this.processSubscribe((ComponentName)intent.getParcelableExtra("co.easimart.api.extra.SUBSCRIBER_COMPONENT"), intent.getStringExtra("co.easimart.api.extra.TOKEN"));
        } else if ("co.easimart.api.action.HANDLE_COMMAND".equals(action)) {
            int commandId = intent.getIntExtra("co.easimart.api.extra.COMMAND_ID", 0);
            this.processHandleCommand(commandId, intent.getExtras());
        } else if ("co.easimart.api.action.NETWORK_AVAILABLE".equals(action)) {
            this.processNetworkAvailable();
        }
    }

    private synchronized void processSubscribe(ComponentName subscriber, String token) {
        if (subscriber == null) {
            Log.w((String)TAG, (String)"No subscriber given.");
            return;
        }
        String oldToken = this.mSubscriptions.get(subscriber);
        if (TextUtils.isEmpty((CharSequence)token)) {
            if (oldToken == null) {
                return;
            }
            this.mSubscriptions.remove(subscriber);
            this.processAndDispatchSubscriberRemoved(subscriber);
        } else {
            if (!TextUtils.isEmpty((CharSequence)oldToken)) {
                this.mSubscriptions.remove(subscriber);
                this.processAndDispatchSubscriberRemoved(subscriber);
            }
            if (!this.onAllowSubscription(subscriber)) {
                return;
            }
            this.mSubscriptions.put(subscriber, token);
            this.processAndDispatchSubscriberAdded(subscriber);
        }
        this.saveSubscriptions();
    }

    private synchronized void processAndDispatchSubscriberAdded(ComponentName subscriber) {
        boolean updateDueToSchedule = false;
        if (this.mSubscriptions.size() == 1) {
            this.onEnabled();
            long updateTimeMillis = this.mSharedPrefs.getLong(PREF_SCHEDULED_UPDATE_TIME_MILLIS, 0L);
            if (updateTimeMillis > 0L) {
                if (updateTimeMillis < System.currentTimeMillis()) {
                    updateDueToSchedule = true;
                    this.unscheduleUpdate();
                    this.onUpdate(3);
                } else {
                    this.setUpdateAlarm(updateTimeMillis);
                }
            }
        }
        this.onSubscriberAdded(subscriber);
        if (!updateDueToSchedule && this.mSubscriptions.size() == 1 && this.mCurrentState.getCurrentArtwork() == null) {
            this.onUpdate(1);
        }
        this.publishCurrentState(subscriber);
    }

    private synchronized void processAndDispatchSubscriberRemoved(ComponentName subscriber) {
        this.onSubscriberRemoved(subscriber);
        if (this.mSubscriptions.size() == 0) {
            this.clearUpdateAlarm();
            this.onDisabled();
        }
    }

    private void processHandleCommand(int commandId, Bundle extras) {
        Log.d((String)TAG, (String)("Received handle command intent, command ID: " + commandId + ", id=" + this.mName));
        if (commandId == 1001) {
            int reason;
            int n = reason = extras.getBoolean("co.easimart.api.extra.SCHEDULED", false) ? 3 : 2;
            if (reason == 3) {
                this.unscheduleUpdate();
            }
            this.onUpdate(reason);
        } else {
            this.onCustomCommand(commandId);
        }
    }

    private void processNetworkAvailable() {
        this.onNetworkAvailable();
    }

    private void setUpdateAlarm(long nextTimeMillis) {
        if (!this.isEnabled()) {
            Log.w((String)TAG, (String)("Source has no subscribers, not actually scheduling next update, id=" + this.mName));
            return;
        }
        if (nextTimeMillis < System.currentTimeMillis()) {
            Log.w((String)TAG, (String)("Refusing to schedule next artwork in the past, id=" + this.mName));
            return;
        }
        AlarmManager am = (AlarmManager)this.getSystemService("alarm");
        am.set(1, nextTimeMillis, this.getHandleNextCommandPendingIntent((Context)this));
        Log.i((String)TAG, (String)("Scheduling next artwork (source " + this.mName + ") at " + new Date(nextTimeMillis)));
    }

    private void clearUpdateAlarm() {
        AlarmManager am = (AlarmManager)this.getSystemService("alarm");
        am.cancel(this.getHandleNextCommandPendingIntent((Context)this));
    }

    private PendingIntent getHandleNextCommandPendingIntent(Context context) {
        return PendingIntent.getService((Context)context, (int)0, (Intent)new Intent("co.easimart.api.action.HANDLE_COMMAND").setComponent(new ComponentName(context, ((Object)((Object)this)).getClass())).setData(Uri.fromParts((String)URI_SCHEME_COMMAND, (String)Integer.toString(1001), null)).putExtra("co.easimart.api.extra.COMMAND_ID", 1001).putExtra("co.easimart.api.extra.SCHEDULED", true), (int)0x8000000);
    }

    private synchronized void publishCurrentState() {
        for (ComponentName subscription : this.mSubscriptions.keySet()) {
            this.publishCurrentState(subscription);
        }
    }

    private synchronized void publishCurrentState(final ComponentName subscriber) {
        String token = this.mSubscriptions.get(subscriber);
        if (TextUtils.isEmpty((CharSequence)token)) {
            Log.w((String)TAG, (String)("Not active, canceling update, id=" + this.mName));
            return;
        }
        Intent intent = new Intent("co.easimart.api.action.PUBLISH_UPDATE").setComponent(subscriber).putExtra("co.easimart.api.extra.TOKEN", token).putExtra("co.easimart.api.extra.STATE", this.mCurrentState != null ? this.mCurrentState.toBundle() : null);
        try {
            ComponentName returnedSubscriber = this.startService(intent);
            if (returnedSubscriber == null) {
                Log.e((String)TAG, (String)("Update wasn't published because subscriber no longer exists, id=" + this.mName));
                this.mServiceHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ArtSource.this.processSubscribe(subscriber, null);
                    }
                });
            }
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("Couldn't publish update, id=" + this.mName), (Throwable)e);
        }
    }

    private synchronized void loadSubscriptions() {
        this.mSubscriptions = new HashMap<ComponentName, String>();
        Set serializedSubscriptions = this.mSharedPrefs.getStringSet(PREF_SUBSCRIPTIONS, null);
        if (serializedSubscriptions != null) {
            for (String serializedSubscription : serializedSubscriptions) {
                String[] arr = serializedSubscription.split("\\|", 2);
                ComponentName subscriber = ComponentName.unflattenFromString((String)arr[0]);
                String token = arr[1];
                this.mSubscriptions.put(subscriber, token);
            }
        }
    }

    private synchronized void saveSubscriptions() {
        HashSet<String> serializedSubscriptions = new HashSet<String>();
        for (ComponentName subscriber : this.mSubscriptions.keySet()) {
            serializedSubscriptions.add(subscriber.flattenToShortString() + "|" + this.mSubscriptions.get(subscriber));
        }
        this.mSharedPrefs.edit().putStringSet(PREF_SUBSCRIPTIONS, serializedSubscriptions).commit();
    }

    private void loadState() {
        String stateString = this.mSharedPrefs.getString(PREF_STATE, null);
        if (stateString != null) {
            try {
                this.mCurrentState = SourceState.fromJson((JSONObject)new JSONTokener(stateString).nextValue());
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("Couldn't deserialize current state, id=" + this.mName), (Throwable)e);
            }
        } else {
            this.mCurrentState = new SourceState();
        }
    }

    private void saveState() {
        try {
            this.mSharedPrefs.edit().putString(PREF_STATE, this.mCurrentState.toJson().toString()).commit();
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Couldn't serialize current state, id=" + this.mName), (Throwable)e);
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            ArtSource.this.onHandleIntent((Intent)msg.obj);
            ArtSource.this.stopSelf(msg.arg1);
        }
    }
}

