/*
 * Decompiled with CFR 0.152.
 */
package co.easimart.provider;

import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import java.net.URISyntaxException;
import org.json.JSONException;
import org.json.JSONObject;

public class Artwork {
    public static final String FONT_TYPE_DEFAULT = "";
    public static final String FONT_TYPE_ELEGANT = "elegant";
    private static final String KEY_IMAGE_URI = "imageUri";
    private static final String KEY_TITLE = "title";
    private static final String KEY_BYLINE = "byline";
    private static final String KEY_ATTRIBUTION = "attribution";
    private static final String KEY_TOKEN = "token";
    private static final String KEY_VIEW_INTENT = "viewIntent";
    private static final String KEY_DETAILS_URI = "detailsUri";
    private static final String KEY_META_FONT = "metaFont";
    private Uri mImageUri;
    private String mTitle;
    private String mByline;
    private String mAttribution;
    private String mToken;
    private Intent mViewIntent;
    private String mMetaFont;

    private Artwork() {
    }

    public Uri getImageUri() {
        return this.mImageUri;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getByline() {
        return this.mByline;
    }

    public String getAttribution() {
        return this.mAttribution;
    }

    public String getToken() {
        return this.mToken;
    }

    public Intent getViewIntent() {
        return this.mViewIntent;
    }

    public String getMetaFont() {
        return this.mMetaFont;
    }

    public void setImageUri(Uri imageUri) {
        this.mImageUri = imageUri;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setByline(String byline) {
        this.mByline = byline;
    }

    public void setAttribution(String attribution) {
        this.mAttribution = attribution;
    }

    public void setToken(String token) {
        this.mToken = token;
    }

    public void setViewIntent(Intent viewIntent) {
        this.mViewIntent = viewIntent;
    }

    public void setMetaFont(String metaFont) {
        this.mMetaFont = metaFont;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_IMAGE_URI, this.mImageUri != null ? this.mImageUri.toString() : null);
        bundle.putString(KEY_TITLE, this.mTitle);
        bundle.putString(KEY_BYLINE, this.mByline);
        bundle.putString(KEY_ATTRIBUTION, this.mAttribution);
        bundle.putString(KEY_TOKEN, this.mToken);
        bundle.putString(KEY_VIEW_INTENT, this.mViewIntent != null ? this.mViewIntent.toUri(1) : null);
        bundle.putString(KEY_META_FONT, this.mMetaFont);
        return bundle;
    }

    public static Artwork fromBundle(Bundle bundle) {
        Builder builder = new Builder().title(bundle.getString(KEY_TITLE)).byline(bundle.getString(KEY_BYLINE)).attribution(bundle.getString(KEY_ATTRIBUTION)).token(bundle.getString(KEY_TOKEN)).metaFont(bundle.getString(KEY_META_FONT));
        String imageUri = bundle.getString(KEY_IMAGE_URI);
        if (!TextUtils.isEmpty((CharSequence)imageUri)) {
            builder.imageUri(Uri.parse((String)imageUri));
        }
        try {
            String viewIntent = bundle.getString(KEY_VIEW_INTENT);
            if (!TextUtils.isEmpty((CharSequence)viewIntent)) {
                builder.viewIntent(Intent.parseUri((String)viewIntent, (int)1));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return builder.build();
    }

    public JSONObject toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(KEY_IMAGE_URI, this.mImageUri != null ? this.mImageUri.toString() : null);
        jsonObject.put(KEY_TITLE, (Object)this.mTitle);
        jsonObject.put(KEY_BYLINE, (Object)this.mByline);
        jsonObject.put(KEY_ATTRIBUTION, (Object)this.mAttribution);
        jsonObject.put(KEY_TOKEN, (Object)this.mToken);
        jsonObject.put(KEY_VIEW_INTENT, this.mViewIntent != null ? this.mViewIntent.toUri(1) : null);
        jsonObject.put(KEY_META_FONT, (Object)this.mMetaFont);
        return jsonObject;
    }

    public static Artwork fromJson(JSONObject jsonObject) throws JSONException {
        Builder builder = new Builder().title(jsonObject.optString(KEY_TITLE)).byline(jsonObject.optString(KEY_BYLINE)).attribution(jsonObject.optString(KEY_ATTRIBUTION)).token(jsonObject.optString(KEY_TOKEN)).metaFont(jsonObject.optString(KEY_META_FONT));
        String imageUri = jsonObject.optString(KEY_IMAGE_URI);
        if (!TextUtils.isEmpty((CharSequence)imageUri)) {
            builder.imageUri(Uri.parse((String)imageUri));
        }
        try {
            String viewIntent = jsonObject.optString(KEY_VIEW_INTENT);
            String detailsUri = jsonObject.optString(KEY_DETAILS_URI);
            if (!TextUtils.isEmpty((CharSequence)viewIntent)) {
                builder.viewIntent(Intent.parseUri((String)viewIntent, (int)1));
            } else if (!TextUtils.isEmpty((CharSequence)detailsUri)) {
                builder.viewIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)detailsUri)));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return builder.build();
    }

    public ContentValues toContentValues() {
        ContentValues values = new ContentValues();
        values.put(KEY_IMAGE_URI, this.mImageUri != null ? this.mImageUri.toString() : null);
        values.put(KEY_TITLE, this.mTitle);
        values.put(KEY_BYLINE, this.mByline);
        values.put(KEY_ATTRIBUTION, this.mAttribution);
        values.put(KEY_TOKEN, this.mToken);
        values.put(KEY_VIEW_INTENT, this.mViewIntent != null ? this.mViewIntent.toUri(1) : null);
        values.put(KEY_META_FONT, this.mMetaFont);
        return values;
    }

    public static Artwork fromCursor(Cursor cursor) {
        int metaFontColumnIndex;
        int viewIntentColumnIndex;
        int tokenColumnIndex;
        int attributionColumnIndex;
        int bylineColumnIndex;
        int titleColumnIndex;
        Builder builder = new Builder();
        int imageUriColumnIndex = cursor.getColumnIndex(KEY_IMAGE_URI);
        if (imageUriColumnIndex != -1) {
            builder.imageUri(Uri.parse((String)cursor.getString(imageUriColumnIndex)));
        }
        if ((titleColumnIndex = cursor.getColumnIndex(KEY_TITLE)) != -1) {
            builder.title(cursor.getString(titleColumnIndex));
        }
        if ((bylineColumnIndex = cursor.getColumnIndex(KEY_BYLINE)) != -1) {
            builder.byline(cursor.getString(bylineColumnIndex));
        }
        if ((attributionColumnIndex = cursor.getColumnIndex(KEY_ATTRIBUTION)) != -1) {
            builder.attribution(cursor.getString(attributionColumnIndex));
        }
        if ((tokenColumnIndex = cursor.getColumnIndex(KEY_TOKEN)) != -1) {
            builder.token(cursor.getString(tokenColumnIndex));
        }
        if ((viewIntentColumnIndex = cursor.getColumnIndex(KEY_VIEW_INTENT)) != -1) {
            try {
                String viewIntent = cursor.getString(viewIntentColumnIndex);
                if (!TextUtils.isEmpty((CharSequence)viewIntent)) {
                    builder.viewIntent(Intent.parseUri((String)viewIntent, (int)1));
                }
            }
            catch (URISyntaxException viewIntent) {
                // empty catch block
            }
        }
        if ((metaFontColumnIndex = cursor.getColumnIndex(KEY_META_FONT)) != -1) {
            builder.metaFont(cursor.getString(metaFontColumnIndex));
        }
        return builder.build();
    }

    public static class Builder {
        private Artwork mArtwork = new Artwork();

        public Builder imageUri(Uri imageUri) {
            this.mArtwork.mImageUri = imageUri;
            return this;
        }

        public Builder title(String title) {
            this.mArtwork.mTitle = title;
            return this;
        }

        public Builder byline(String byline) {
            this.mArtwork.mByline = byline;
            return this;
        }

        public Builder attribution(String attribution) {
            this.mArtwork.mAttribution = attribution;
            return this;
        }

        public Builder token(String token) {
            this.mArtwork.mToken = token;
            return this;
        }

        public Builder viewIntent(Intent viewIntent) {
            this.mArtwork.mViewIntent = viewIntent;
            return this;
        }

        public Builder metaFont(String metaFont) {
            this.mArtwork.mMetaFont = metaFont;
            return this;
        }

        public Artwork build() {
            return this.mArtwork;
        }
    }
}

