/*
 * Decompiled with CFR 0.152.
 */
package co.easimart.provider;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Looper;
import android.provider.BaseColumns;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class DbContract {
    public static final String AUTHORITY = "co.easimart.apps";
    private static final String SCHEME = "content://";

    private DbContract() {
    }

    public static final class Artwork
    implements BaseColumns {
        public static final String COLUMN_NAME_IMAGE_URI = "imageUri";
        public static final String COLUMN_NAME_TITLE = "title";
        public static final String COLUMN_NAME_BYLINE = "byline";
        public static final String COLUMN_NAME_ATTRIBUTION = "attribution";
        public static final String COLUMN_NAME_TOKEN = "token";
        public static final String COLUMN_NAME_VIEW_INTENT = "viewIntent";
        public static final String COLUMN_NAME_META_FONT = "metaFont";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.easimart.apps.artwork";
        public static final String TABLE_NAME = "artwork";
        public static final Uri CONTENT_URI = Uri.parse((String)"content://co.easimart.apps/artwork");
        public static final String ACTION_ARTWORK_CHANGED = "co.easimart.apps.ACTION_ARTWORK_CHANGED";

        private Artwork() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static co.easimart.provider.Artwork getCurrentArtwork(Context context) {
            ContentResolver contentResolver = context.getContentResolver();
            Cursor cursor = contentResolver.query(CONTENT_URI, null, null, null, null);
            if (cursor == null) {
                return null;
            }
            try {
                if (!cursor.moveToFirst()) {
                    co.easimart.provider.Artwork artwork = null;
                    return artwork;
                }
                co.easimart.provider.Artwork artwork = co.easimart.provider.Artwork.fromCursor(cursor);
                return artwork;
            }
            finally {
                cursor.close();
            }
        }

        public static Bitmap getCurrentArtworkBitmap(Context context) throws FileNotFoundException {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                throw new IllegalStateException("getCurrentArtworkBitmap cannot be called on the main thread");
            }
            ContentResolver contentResolver = context.getContentResolver();
            return BitmapFactory.decodeStream((InputStream)contentResolver.openInputStream(CONTENT_URI));
        }
    }
}

