/*
 * Decompiled with CFR 0.152.
 */
package co.easimart.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.preference.PreferenceManager;
import android.util.Log;
import co.easimart.provider.DbContract;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;

public class DbProvider
extends ContentProvider {
    private static final String TAG = DbProvider.class.getSimpleName();
    private static final String CURRENT_ARTWORK_LOCATION = "CURRENT_ARTWORK_LOCATION";
    private static final int ARTWORK = 1;
    private static final String DATABASE_NAME = "easimart.db";
    private static final int DATABASE_VERSION = 2;
    private static final UriMatcher uriMatcher = DbProvider.buildUriMatcher();
    private final HashMap<String, String> allColumnProjectionMap = DbProvider.buildAllColumnProjectionMap();
    private DatabaseHelper databaseHelper;

    public static boolean saveCurrentArtworkLocation(Context context, File currentArtwork) {
        if (currentArtwork == null || !currentArtwork.exists()) {
            Log.w((String)TAG, (String)("File " + currentArtwork + " is not valid"));
            return false;
        }
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        sharedPreferences.edit().putString(CURRENT_ARTWORK_LOCATION, currentArtwork.getAbsolutePath()).commit();
        return true;
    }

    private static HashMap<String, String> buildAllColumnProjectionMap() {
        HashMap<String, String> allColumnProjectionMap = new HashMap<String, String>();
        allColumnProjectionMap.put("_id", "_id");
        allColumnProjectionMap.put("imageUri", "imageUri");
        allColumnProjectionMap.put("title", "title");
        allColumnProjectionMap.put("byline", "byline");
        allColumnProjectionMap.put("attribution", "attribution");
        allColumnProjectionMap.put("token", "token");
        allColumnProjectionMap.put("viewIntent", "viewIntent");
        allColumnProjectionMap.put("metaFont", "metaFont");
        return allColumnProjectionMap;
    }

    private static UriMatcher buildUriMatcher() {
        UriMatcher matcher = new UriMatcher(-1);
        matcher.addURI("co.easimart.apps", "artwork", 1);
        return matcher;
    }

    public int delete(Uri uri, String where, String[] whereArgs) {
        throw new UnsupportedOperationException("Deletes are not supported");
    }

    public String getType(Uri uri) {
        switch (uriMatcher.match(uri)) {
            case 1: {
                return "vnd.android.cursor.dir/vnd.easimart.apps.artwork";
            }
        }
        throw new IllegalArgumentException("Unknown URI " + uri);
    }

    public Uri insert(Uri uri, ContentValues values) {
        long rowId;
        if (uriMatcher.match(uri) != 1) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        if (values == null) {
            throw new IllegalArgumentException("Invalid ContentValues: must not be null");
        }
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        int countUpdated = db.update("artwork", values, "_id=1", null);
        if (countUpdated != 1 && (rowId = db.insert("artwork", "imageUri", values)) <= 0L) {
            throw new SQLException("Failed to insert row into " + uri);
        }
        this.getContext().getContentResolver().notifyChange(DbContract.Artwork.CONTENT_URI, null);
        this.getContext().sendBroadcast(new Intent("co.easimart.apps.ACTION_ARTWORK_CHANGED"));
        return DbContract.Artwork.CONTENT_URI;
    }

    public boolean onCreate() {
        this.databaseHelper = new DatabaseHelper(this.getContext());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        if (uriMatcher.match(uri) != 1) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        qb.setTables("artwork");
        qb.setProjectionMap(this.allColumnProjectionMap);
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        Cursor c = qb.query(db, projection, selection, selectionArgs, null, null, sortOrder, null);
        c.setNotificationUri(this.getContext().getContentResolver(), uri);
        return c;
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        if (uriMatcher.match(uri) != 1) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        if (!"r".equals(mode)) {
            throw new IllegalArgumentException("Invalid mode for opening file: " + mode + ". Only 'r' is valid");
        }
        String currentArtworkLocation = PreferenceManager.getDefaultSharedPreferences((Context)this.getContext()).getString(CURRENT_ARTWORK_LOCATION, null);
        if (currentArtworkLocation == null) {
            throw new FileNotFoundException("No artwork image is set");
        }
        File file = new File(currentArtworkLocation);
        if (!file.exists()) {
            throw new FileNotFoundException("File " + currentArtworkLocation + " does not exist");
        }
        return ParcelFileDescriptor.open((File)file, (int)0x10000000);
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Updates are not allowed: insert does an insert or update operation");
    }

    static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context) {
            super(context, DbProvider.DATABASE_NAME, null, 2);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE artwork (_id INTEGER PRIMARY KEY AUTOINCREMENT,imageUri TEXT,title TEXT,byline TEXT,attribution TEXT,token TEXT,metaFont TEXT,viewIntent TEXT);");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE IF EXISTS artwork");
            this.onCreate(db);
        }
    }
}

