/*
 * Decompiled with CFR 0.152.
 */
package co.easimart.provider;

import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.PowerManager;
import android.util.Log;
import co.easimart.provider.ArtSource;

public abstract class RemoteArtSource
extends ArtSource {
    private static final String TAG = RemoteArtSource.class.getSimpleName();
    private static final int FETCH_WAKELOCK_TIMEOUT_MILLIS = 30000;
    private static final int INITIAL_RETRY_DELAY_MILLIS = 10000;
    private static final String PREF_RETRY_ATTEMPT = "retry_attempt";
    private String mName;

    public RemoteArtSource(String name) {
        super(name);
        this.mName = name;
    }

    protected abstract void onTryUpdate(int var1) throws RetryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onUpdate(int reason) {
        PowerManager pwm = (PowerManager)this.getSystemService("power");
        PowerManager.WakeLock lock = pwm.newWakeLock(1, this.mName);
        lock.acquire(30000L);
        SharedPreferences sp = this.getSharedPreferences();
        try {
            NetworkInfo ni = ((ConnectivityManager)this.getSystemService("connectivity")).getActiveNetworkInfo();
            if (ni == null || !ni.isConnected()) {
                Log.d((String)TAG, (String)("No network connection; not attempting to fetch update, id=" + this.mName));
                throw new RetryException();
            }
            sp.edit().remove(PREF_RETRY_ATTEMPT).apply();
            this.setWantsNetworkAvailable(false);
            this.onTryUpdate(reason);
        }
        catch (RetryException e) {
            Log.w((String)TAG, (String)("Error fetching, scheduling retry, id=" + this.mName));
            int retryAttempt = sp.getInt(PREF_RETRY_ATTEMPT, 0);
            this.scheduleUpdate(System.currentTimeMillis() + (long)(10000 << retryAttempt));
            sp.edit().putInt(PREF_RETRY_ATTEMPT, retryAttempt + 1).apply();
            this.setWantsNetworkAvailable(true);
        }
        finally {
            if (lock.isHeld()) {
                lock.release();
            }
        }
    }

    @Override
    protected void onDisabled() {
        super.onDisabled();
        this.getSharedPreferences().edit().remove(PREF_RETRY_ATTEMPT).commit();
        this.setWantsNetworkAvailable(false);
    }

    @Override
    protected void onNetworkAvailable() {
        super.onNetworkAvailable();
        if (this.getSharedPreferences().getInt(PREF_RETRY_ATTEMPT, 0) > 0) {
            this.onUpdate(0);
        }
    }

    public static class RetryException
    extends Exception {
        public RetryException() {
        }

        public RetryException(Throwable cause) {
            super(cause);
        }
    }
}

