/*
 * Decompiled with CFR 0.152.
 */
package co.easimart.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.Matrix3f;
import android.support.v8.renderscript.RSInvalidStateException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.support.v8.renderscript.ScriptIntrinsicColorMatrix;
import co.easimart.util.MathUtil;

public class ImageBlurrer {
    public static final int MAX_SUPPORTED_BLUR_PIXELS = 25;
    private RenderScript mRS;
    private ScriptIntrinsicBlur mSIBlur;
    private ScriptIntrinsicColorMatrix mSIGrey;
    private Allocation mTmp1;
    private Allocation mTmp2;

    public ImageBlurrer(Context context) {
        this.mRS = RenderScript.create((Context)context);
        this.mSIBlur = ScriptIntrinsicBlur.create((RenderScript)this.mRS, (Element)Element.U8_4((RenderScript)this.mRS));
        this.mSIGrey = ScriptIntrinsicColorMatrix.create((RenderScript)this.mRS, (Element)Element.U8_4((RenderScript)this.mRS));
    }

    public Bitmap blurBitmap(Bitmap src, float radius, float desaturateAmount) {
        if (src == null) {
            return null;
        }
        Bitmap dest = src.copy(src.getConfig(), false);
        if (radius == 0.0f && desaturateAmount == 0.0f) {
            return dest;
        }
        if (this.mTmp1 != null) {
            this.mTmp1.destroy();
        }
        if (this.mTmp2 != null) {
            try {
                this.mTmp2.destroy();
            }
            catch (RSInvalidStateException rSInvalidStateException) {
                // empty catch block
            }
        }
        this.mTmp1 = Allocation.createFromBitmap((RenderScript)this.mRS, (Bitmap)src);
        this.mTmp2 = Allocation.createFromBitmap((RenderScript)this.mRS, (Bitmap)dest);
        if (radius > 0.0f && desaturateAmount > 0.0f) {
            this.doBlur(radius, this.mTmp1, this.mTmp2);
            this.doDesaturate(MathUtil.constrain(0.0f, 1.0f, desaturateAmount), this.mTmp2, this.mTmp1);
            this.mTmp1.copyTo(dest);
        } else if (radius > 0.0f) {
            this.doBlur(radius, this.mTmp1, this.mTmp2);
            this.mTmp2.copyTo(dest);
        } else {
            this.doDesaturate(MathUtil.constrain(0.0f, 1.0f, desaturateAmount), this.mTmp1, this.mTmp2);
            this.mTmp2.copyTo(dest);
        }
        return dest;
    }

    private void doBlur(float amount, Allocation input, Allocation output) {
        this.mSIBlur.setRadius(amount);
        this.mSIBlur.setInput(input);
        this.mSIBlur.forEach(output);
    }

    private void doDesaturate(float normalizedAmount, Allocation input, Allocation output) {
        Matrix3f m = new Matrix3f(new float[]{MathUtil.interpolate(1.0f, 0.299f, normalizedAmount), MathUtil.interpolate(0.0f, 0.299f, normalizedAmount), MathUtil.interpolate(0.0f, 0.299f, normalizedAmount), MathUtil.interpolate(0.0f, 0.587f, normalizedAmount), MathUtil.interpolate(1.0f, 0.587f, normalizedAmount), MathUtil.interpolate(0.0f, 0.587f, normalizedAmount), MathUtil.interpolate(0.0f, 0.114f, normalizedAmount), MathUtil.interpolate(0.0f, 0.114f, normalizedAmount), MathUtil.interpolate(1.0f, 0.114f, normalizedAmount)});
        this.mSIGrey.setColorMatrix(m);
        this.mSIGrey.forEach(input, output);
    }

    public void destroy() {
        this.mSIBlur.destroy();
        if (this.mTmp1 != null) {
            this.mTmp1.destroy();
        }
        if (this.mTmp2 != null) {
            this.mTmp2.destroy();
        }
        this.mRS.destroy();
    }
}

