/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NodeInfoNetworkInterface
implements JsonpSerializable {
    private final String address;
    private final String macAddress;
    private final String name;
    public static final JsonpDeserializer<NodeInfoNetworkInterface> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoNetworkInterface::setupNodeInfoNetworkInterfaceDeserializer);

    private NodeInfoNetworkInterface(Builder builder) {
        this.address = ApiTypeHelper.requireNonNull(builder.address, this, "address");
        this.macAddress = ApiTypeHelper.requireNonNull(builder.macAddress, this, "macAddress");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static NodeInfoNetworkInterface of(Function<Builder, ObjectBuilder<NodeInfoNetworkInterface>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String address() {
        return this.address;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("address");
        generator.write(this.address);
        generator.writeKey("mac_address");
        generator.write(this.macAddress);
        generator.writeKey("name");
        generator.write(this.name);
    }

    protected static void setupNodeInfoNetworkInterfaceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::address, JsonpDeserializer.stringDeserializer(), "address");
        op.add(Builder::macAddress, JsonpDeserializer.stringDeserializer(), "mac_address");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeInfoNetworkInterface> {
        private String address;
        private String macAddress;
        private String name;

        public final Builder address(String value) {
            this.address = value;
            return this;
        }

        public final Builder macAddress(String value) {
            this.macAddress = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        public NodeInfoNetworkInterface build() {
            this._checkSingleUse();
            return new NodeInfoNetworkInterface(this);
        }
    }
}

