/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.segments;

import co.elastic.clients.elasticsearch.indices.segments.ShardsSegment;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class IndexSegment
implements JsonpSerializable {
    private final Map<String, List<ShardsSegment>> shards;
    public static final JsonpDeserializer<IndexSegment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSegment::setupIndexSegmentDeserializer);

    private IndexSegment(Builder builder) {
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
    }

    public static IndexSegment of(Function<Builder, ObjectBuilder<IndexSegment>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, List<ShardsSegment>> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, List<ShardsSegment>> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (ShardsSegment item1 : item0.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupIndexSegmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(ShardsSegment._DESERIALIZER)), "shards");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexSegment> {
        private Map<String, List<ShardsSegment>> shards;

        public final Builder shards(Map<String, List<ShardsSegment>> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        public final Builder shards(String key, List<ShardsSegment> value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        @Override
        public IndexSegment build() {
            this._checkSingleUse();
            return new IndexSegment(this);
        }
    }
}

