/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.Normalizer;
import co.elastic.clients.elasticsearch._types.analysis.NormalizerVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CustomNormalizer
implements NormalizerVariant,
JsonpSerializable {
    private final List<String> charFilter;
    private final List<String> filter;
    public static final JsonpDeserializer<CustomNormalizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomNormalizer::setupCustomNormalizerDeserializer);

    private CustomNormalizer(Builder builder) {
        this.charFilter = ApiTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
    }

    public static CustomNormalizer of(Function<Builder, ObjectBuilder<CustomNormalizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Normalizer.Kind _normalizerKind() {
        return Normalizer.Kind.Custom;
    }

    public final List<String> charFilter() {
        return this.charFilter;
    }

    public final List<String> filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "custom");
        if (ApiTypeHelper.isDefined(this.charFilter)) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (String item0 : this.charFilter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (String item0 : this.filter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCustomNormalizerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "char_filter");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filter");
        op.ignore("type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CustomNormalizer> {
        @Nullable
        private List<String> charFilter;
        @Nullable
        private List<String> filter;

        public final Builder charFilter(List<String> list) {
            this.charFilter = Builder._listAddAll(this.charFilter, list);
            return this;
        }

        public final Builder charFilter(String value, String ... values) {
            this.charFilter = Builder._listAdd(this.charFilter, value, values);
            return this;
        }

        public final Builder filter(List<String> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        public final Builder filter(String value, String ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CustomNormalizer build() {
            this._checkSingleUse();
            return new CustomNormalizer(this);
        }
    }
}

