/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.ThreadPoolResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ThreadPoolRequest
extends CatRequestBase {
    private final List<String> threadPoolPatterns;
    @Nullable
    private final Time time;
    public static final Endpoint<ThreadPoolRequest, ThreadPoolResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ThreadPoolRequest, ThreadPoolResponse>("es/cat.thread_pool", request -> "GET", request -> {
        boolean _threadPoolPatterns = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.threadPoolPatterns())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/thread_pool");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/thread_pool");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.threadPoolPatterns.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.time != null) {
            params.put("time", request.time._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ThreadPoolResponse._DESERIALIZER);

    private ThreadPoolRequest(Builder builder) {
        this.threadPoolPatterns = ApiTypeHelper.unmodifiable(builder.threadPoolPatterns);
        this.time = builder.time;
    }

    public static ThreadPoolRequest of(Function<Builder, ObjectBuilder<ThreadPoolRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> threadPoolPatterns() {
        return this.threadPoolPatterns;
    }

    @Nullable
    public final Time time() {
        return this.time;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ThreadPoolRequest> {
        @Nullable
        private List<String> threadPoolPatterns;
        @Nullable
        private Time time;

        public final Builder threadPoolPatterns(List<String> list) {
            this.threadPoolPatterns = Builder._listAddAll(this.threadPoolPatterns, list);
            return this;
        }

        public final Builder threadPoolPatterns(String value, String ... values) {
            this.threadPoolPatterns = Builder._listAdd(this.threadPoolPatterns, value, values);
            return this;
        }

        public final Builder time(@Nullable Time value) {
            this.time = value;
            return this;
        }

        public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.time(fn.apply(new Time.Builder()).build());
        }

        @Override
        public ThreadPoolRequest build() {
            this._checkSingleUse();
            return new ThreadPoolRequest(this);
        }
    }
}

