/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.CompletionSuggester;
import co.elastic.clients.elasticsearch.core.search.FieldSuggesterVariant;
import co.elastic.clients.elasticsearch.core.search.PhraseSuggester;
import co.elastic.clients.elasticsearch.core.search.TermSuggester;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FieldSuggester
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<FieldSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldSuggester::setupFieldSuggesterDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public FieldSuggester(FieldSuggesterVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._fieldSuggesterKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private FieldSuggester(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static FieldSuggester of(Function<Builder, ObjectBuilder<FieldSuggester>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCompletion() {
        return this._kind == Kind.Completion;
    }

    public CompletionSuggester completion() {
        return (CompletionSuggester)TaggedUnionUtils.get(this, Kind.Completion);
    }

    public boolean isPhrase() {
        return this._kind == Kind.Phrase;
    }

    public PhraseSuggester phrase() {
        return (PhraseSuggester)TaggedUnionUtils.get(this, Kind.Phrase);
    }

    public boolean isPrefix() {
        return this._kind == Kind.Prefix;
    }

    public String prefix() {
        return (String)TaggedUnionUtils.get(this, Kind.Prefix);
    }

    public boolean isRegex() {
        return this._kind == Kind.Regex;
    }

    public String regex() {
        return (String)TaggedUnionUtils.get(this, Kind.Regex);
    }

    public boolean isTerm() {
        return this._kind == Kind.Term;
    }

    public TermSuggester term() {
        return (TermSuggester)TaggedUnionUtils.get(this, Kind.Term);
    }

    public boolean isText() {
        return this._kind == Kind.Text;
    }

    public String text() {
        return (String)TaggedUnionUtils.get(this, Kind.Text);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Prefix: {
                    generator.write((String)this._value);
                    break;
                }
                case Regex: {
                    generator.write((String)this._value);
                    break;
                }
                case Text: {
                    generator.write((String)this._value);
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupFieldSuggesterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::completion, CompletionSuggester._DESERIALIZER, "completion");
        op.add(Builder::phrase, PhraseSuggester._DESERIALIZER, "phrase");
        op.add(Builder::prefix, JsonpDeserializer.stringDeserializer(), "prefix");
        op.add(Builder::regex, JsonpDeserializer.stringDeserializer(), "regex");
        op.add(Builder::term, TermSuggester._DESERIALIZER, "term");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldSuggester> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<FieldSuggester> completion(CompletionSuggester v) {
            this._kind = Kind.Completion;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldSuggester> completion(Function<CompletionSuggester.Builder, ObjectBuilder<CompletionSuggester>> fn) {
            return this.completion(fn.apply(new CompletionSuggester.Builder()).build());
        }

        public ObjectBuilder<FieldSuggester> phrase(PhraseSuggester v) {
            this._kind = Kind.Phrase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldSuggester> phrase(Function<PhraseSuggester.Builder, ObjectBuilder<PhraseSuggester>> fn) {
            return this.phrase(fn.apply(new PhraseSuggester.Builder()).build());
        }

        public ObjectBuilder<FieldSuggester> prefix(String v) {
            this._kind = Kind.Prefix;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldSuggester> regex(String v) {
            this._kind = Kind.Regex;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldSuggester> term(TermSuggester v) {
            this._kind = Kind.Term;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldSuggester> term(Function<TermSuggester.Builder, ObjectBuilder<TermSuggester>> fn) {
            return this.term(fn.apply(new TermSuggester.Builder()).build());
        }

        public ObjectBuilder<FieldSuggester> text(String v) {
            this._kind = Kind.Text;
            this._value = v;
            return this;
        }

        @Override
        public FieldSuggester build() {
            this._checkSingleUse();
            return new FieldSuggester(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Completion("completion"),
        Phrase("phrase"),
        Prefix("prefix"),
        Regex("regex"),
        Term("term"),
        Text("text");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

