/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.resolve_index;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ResolveIndexAliasItem
implements JsonpSerializable {
    private final String name;
    private final List<String> indices;
    public static final JsonpDeserializer<ResolveIndexAliasItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexAliasItem::setupResolveIndexAliasItemDeserializer);

    private ResolveIndexAliasItem(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
    }

    public static ResolveIndexAliasItem of(Function<Builder, ObjectBuilder<ResolveIndexAliasItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final List<String> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupResolveIndexAliasItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ResolveIndexAliasItem> {
        private String name;
        private List<String> indices;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ResolveIndexAliasItem build() {
            this._checkSingleUse();
            return new ResolveIndexAliasItem(this);
        }
    }
}

