/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.segments;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class Segment
implements JsonpSerializable {
    private final Map<String, String> attributes;
    private final boolean committed;
    private final boolean compound;
    private final long deletedDocs;
    private final int generation;
    private final double memoryInBytes;
    private final boolean search;
    private final double sizeInBytes;
    private final long numDocs;
    private final String version;
    public static final JsonpDeserializer<Segment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Segment::setupSegmentDeserializer);

    private Segment(Builder builder) {
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.committed = ApiTypeHelper.requireNonNull(builder.committed, this, "committed");
        this.compound = ApiTypeHelper.requireNonNull(builder.compound, this, "compound");
        this.deletedDocs = ApiTypeHelper.requireNonNull(builder.deletedDocs, this, "deletedDocs");
        this.generation = ApiTypeHelper.requireNonNull(builder.generation, this, "generation");
        this.memoryInBytes = ApiTypeHelper.requireNonNull(builder.memoryInBytes, this, "memoryInBytes");
        this.search = ApiTypeHelper.requireNonNull(builder.search, this, "search");
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, this, "sizeInBytes");
        this.numDocs = ApiTypeHelper.requireNonNull(builder.numDocs, this, "numDocs");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static Segment of(Function<Builder, ObjectBuilder<Segment>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final boolean committed() {
        return this.committed;
    }

    public final boolean compound() {
        return this.compound;
    }

    public final long deletedDocs() {
        return this.deletedDocs;
    }

    public final int generation() {
        return this.generation;
    }

    public final double memoryInBytes() {
        return this.memoryInBytes;
    }

    public final boolean search() {
        return this.search;
    }

    public final double sizeInBytes() {
        return this.sizeInBytes;
    }

    public final long numDocs() {
        return this.numDocs;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.attributes.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("committed");
        generator.write(this.committed);
        generator.writeKey("compound");
        generator.write(this.compound);
        generator.writeKey("deleted_docs");
        generator.write(this.deletedDocs);
        generator.writeKey("generation");
        generator.write(this.generation);
        generator.writeKey("memory_in_bytes");
        generator.write(this.memoryInBytes);
        generator.writeKey("search");
        generator.write(this.search);
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        generator.writeKey("num_docs");
        generator.write(this.numDocs);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupSegmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::committed, JsonpDeserializer.booleanDeserializer(), "committed");
        op.add(Builder::compound, JsonpDeserializer.booleanDeserializer(), "compound");
        op.add(Builder::deletedDocs, JsonpDeserializer.longDeserializer(), "deleted_docs");
        op.add(Builder::generation, JsonpDeserializer.integerDeserializer(), "generation");
        op.add(Builder::memoryInBytes, JsonpDeserializer.doubleDeserializer(), "memory_in_bytes");
        op.add(Builder::search, JsonpDeserializer.booleanDeserializer(), "search");
        op.add(Builder::sizeInBytes, JsonpDeserializer.doubleDeserializer(), "size_in_bytes");
        op.add(Builder::numDocs, JsonpDeserializer.longDeserializer(), "num_docs");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Segment> {
        private Map<String, String> attributes;
        private Boolean committed;
        private Boolean compound;
        private Long deletedDocs;
        private Integer generation;
        private Double memoryInBytes;
        private Boolean search;
        private Double sizeInBytes;
        private Long numDocs;
        private String version;

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder committed(boolean value) {
            this.committed = value;
            return this;
        }

        public final Builder compound(boolean value) {
            this.compound = value;
            return this;
        }

        public final Builder deletedDocs(long value) {
            this.deletedDocs = value;
            return this;
        }

        public final Builder generation(int value) {
            this.generation = value;
            return this;
        }

        public final Builder memoryInBytes(double value) {
            this.memoryInBytes = value;
            return this;
        }

        public final Builder search(boolean value) {
            this.search = value;
            return this;
        }

        public final Builder sizeInBytes(double value) {
            this.sizeInBytes = value;
            return this;
        }

        public final Builder numDocs(long value) {
            this.numDocs = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Segment build() {
            this._checkSingleUse();
            return new Segment(this);
        }
    }
}

