/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.transform.Sync;
import co.elastic.clients.elasticsearch.transform.SyncVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TimeSync
implements SyncVariant,
JsonpSerializable {
    @Nullable
    private final Time delay;
    private final String field;
    public static final JsonpDeserializer<TimeSync> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimeSync::setupTimeSyncDeserializer);

    private TimeSync(Builder builder) {
        this.delay = builder.delay;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
    }

    public static TimeSync of(Function<Builder, ObjectBuilder<TimeSync>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Sync.Kind _syncKind() {
        return Sync.Kind.Time;
    }

    @Nullable
    public final Time delay() {
        return this.delay;
    }

    public final String field() {
        return this.field;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.delay != null) {
            generator.writeKey("delay");
            this.delay.serialize(generator, mapper);
        }
        generator.writeKey("field");
        generator.write(this.field);
    }

    protected static void setupTimeSyncDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::delay, Time._DESERIALIZER, "delay");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TimeSync> {
        @Nullable
        private Time delay;
        private String field;

        public final Builder delay(@Nullable Time value) {
            this.delay = value;
            return this;
        }

        public final Builder delay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.delay(fn.apply(new Time.Builder()).build());
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TimeSync build() {
            this._checkSingleUse();
            return new TimeSync(this);
        }
    }
}

