/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.EnumSet;

public class NamedDeserializer<T>
implements JsonpDeserializer<T> {
    private static final EnumSet<JsonParser.Event> events = EnumSet.of(JsonParser.Event.START_OBJECT, new JsonParser.Event[]{JsonParser.Event.START_ARRAY, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NULL});
    private final String name;

    public NamedDeserializer(String name) {
        this.name = name;
    }

    @Override
    public EnumSet<JsonParser.Event> nativeEvents() {
        return events;
    }

    @Override
    public EnumSet<JsonParser.Event> acceptedEvents() {
        return events;
    }

    @Override
    public T deserialize(JsonParser parser, JsonpMapper mapper) {
        JsonpDeserializer deserializer = (JsonpDeserializer)mapper.attribute(this.name);
        if (deserializer == null) {
            throw new JsonParsingException("Missing deserializer for generic type: " + this.name, parser.getLocation());
        }
        return (T)deserializer.deserialize(parser, mapper);
    }

    @Override
    public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        JsonpDeserializer deserializer = (JsonpDeserializer)mapper.attribute(this.name);
        if (deserializer == null) {
            throw new JsonParsingException("Missing deserializer for generic type: " + this.name, parser.getLocation());
        }
        return (T)deserializer.deserialize(parser, mapper, event);
    }
}

