/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.field_usage_stats;

import co.elastic.clients.elasticsearch.indices.field_usage_stats.UsageStatsShards;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class UsageStatsIndex
implements JsonpSerializable {
    private final List<UsageStatsShards> shards;
    public static final JsonpDeserializer<UsageStatsIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UsageStatsIndex::setupUsageStatsIndexDeserializer);

    private UsageStatsIndex(Builder builder) {
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
    }

    public static UsageStatsIndex of(Function<Builder, ObjectBuilder<UsageStatsIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<UsageStatsShards> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartArray();
            for (UsageStatsShards item0 : this.shards) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupUsageStatsIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(UsageStatsShards._DESERIALIZER), "shards");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UsageStatsIndex> {
        private List<UsageStatsShards> shards;

        public final Builder shards(List<UsageStatsShards> list) {
            this.shards = Builder._listAddAll(this.shards, list);
            return this;
        }

        public final Builder shards(UsageStatsShards value, UsageStatsShards ... values) {
            this.shards = Builder._listAdd(this.shards, value, values);
            return this;
        }

        public final Builder shards(Function<UsageStatsShards.Builder, ObjectBuilder<UsageStatsShards>> fn) {
            return this.shards(fn.apply(new UsageStatsShards.Builder()).build(), new UsageStatsShards[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UsageStatsIndex build() {
            this._checkSingleUse();
            return new UsageStatsIndex(this);
        }
    }
}

