/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DiscoveryNode;
import co.elastic.clients.elasticsearch.ml.TrainedModelAllocationRoutingTable;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelDeploymentNodesStats
implements JsonpSerializable {
    private final double averageInferenceTimeMs;
    private final int errorCount;
    private final int inferenceCount;
    private final int inferenceThreads;
    private final long lastAccess;
    private final int modelThreads;
    private final DiscoveryNode node;
    private final int numberOfPendingRequests;
    private final int rejectionExecutionCount;
    private final TrainedModelAllocationRoutingTable routingState;
    private final long startTime;
    private final int timeoutCount;
    public static final JsonpDeserializer<TrainedModelDeploymentNodesStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelDeploymentNodesStats::setupTrainedModelDeploymentNodesStatsDeserializer);

    private TrainedModelDeploymentNodesStats(Builder builder) {
        this.averageInferenceTimeMs = ApiTypeHelper.requireNonNull(builder.averageInferenceTimeMs, this, "averageInferenceTimeMs");
        this.errorCount = ApiTypeHelper.requireNonNull(builder.errorCount, this, "errorCount");
        this.inferenceCount = ApiTypeHelper.requireNonNull(builder.inferenceCount, this, "inferenceCount");
        this.inferenceThreads = ApiTypeHelper.requireNonNull(builder.inferenceThreads, this, "inferenceThreads");
        this.lastAccess = ApiTypeHelper.requireNonNull(builder.lastAccess, this, "lastAccess");
        this.modelThreads = ApiTypeHelper.requireNonNull(builder.modelThreads, this, "modelThreads");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.numberOfPendingRequests = ApiTypeHelper.requireNonNull(builder.numberOfPendingRequests, this, "numberOfPendingRequests");
        this.rejectionExecutionCount = ApiTypeHelper.requireNonNull(builder.rejectionExecutionCount, this, "rejectionExecutionCount");
        this.routingState = ApiTypeHelper.requireNonNull(builder.routingState, this, "routingState");
        this.startTime = ApiTypeHelper.requireNonNull(builder.startTime, this, "startTime");
        this.timeoutCount = ApiTypeHelper.requireNonNull(builder.timeoutCount, this, "timeoutCount");
    }

    public static TrainedModelDeploymentNodesStats of(Function<Builder, ObjectBuilder<TrainedModelDeploymentNodesStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double averageInferenceTimeMs() {
        return this.averageInferenceTimeMs;
    }

    public final int errorCount() {
        return this.errorCount;
    }

    public final int inferenceCount() {
        return this.inferenceCount;
    }

    public final int inferenceThreads() {
        return this.inferenceThreads;
    }

    public final long lastAccess() {
        return this.lastAccess;
    }

    public final int modelThreads() {
        return this.modelThreads;
    }

    public final DiscoveryNode node() {
        return this.node;
    }

    public final int numberOfPendingRequests() {
        return this.numberOfPendingRequests;
    }

    public final int rejectionExecutionCount() {
        return this.rejectionExecutionCount;
    }

    public final TrainedModelAllocationRoutingTable routingState() {
        return this.routingState;
    }

    public final long startTime() {
        return this.startTime;
    }

    public final int timeoutCount() {
        return this.timeoutCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("average_inference_time_ms");
        generator.write(this.averageInferenceTimeMs);
        generator.writeKey("error_count");
        generator.write(this.errorCount);
        generator.writeKey("inference_count");
        generator.write(this.inferenceCount);
        generator.writeKey("inference_threads");
        generator.write(this.inferenceThreads);
        generator.writeKey("last_access");
        generator.write(this.lastAccess);
        generator.writeKey("model_threads");
        generator.write(this.modelThreads);
        generator.writeKey("node");
        this.node.serialize(generator, mapper);
        generator.writeKey("number_of_pending_requests");
        generator.write(this.numberOfPendingRequests);
        generator.writeKey("rejection_execution_count");
        generator.write(this.rejectionExecutionCount);
        generator.writeKey("routing_state");
        this.routingState.serialize(generator, mapper);
        generator.writeKey("start_time");
        generator.write(this.startTime);
        generator.writeKey("timeout_count");
        generator.write(this.timeoutCount);
    }

    protected static void setupTrainedModelDeploymentNodesStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::averageInferenceTimeMs, JsonpDeserializer.doubleDeserializer(), "average_inference_time_ms");
        op.add(Builder::errorCount, JsonpDeserializer.integerDeserializer(), "error_count");
        op.add(Builder::inferenceCount, JsonpDeserializer.integerDeserializer(), "inference_count");
        op.add(Builder::inferenceThreads, JsonpDeserializer.integerDeserializer(), "inference_threads");
        op.add(Builder::lastAccess, JsonpDeserializer.longDeserializer(), "last_access");
        op.add(Builder::modelThreads, JsonpDeserializer.integerDeserializer(), "model_threads");
        op.add(Builder::node, DiscoveryNode._DESERIALIZER, "node");
        op.add(Builder::numberOfPendingRequests, JsonpDeserializer.integerDeserializer(), "number_of_pending_requests");
        op.add(Builder::rejectionExecutionCount, JsonpDeserializer.integerDeserializer(), "rejection_execution_count");
        op.add(Builder::routingState, TrainedModelAllocationRoutingTable._DESERIALIZER, "routing_state");
        op.add(Builder::startTime, JsonpDeserializer.longDeserializer(), "start_time");
        op.add(Builder::timeoutCount, JsonpDeserializer.integerDeserializer(), "timeout_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelDeploymentNodesStats> {
        private Double averageInferenceTimeMs;
        private Integer errorCount;
        private Integer inferenceCount;
        private Integer inferenceThreads;
        private Long lastAccess;
        private Integer modelThreads;
        private DiscoveryNode node;
        private Integer numberOfPendingRequests;
        private Integer rejectionExecutionCount;
        private TrainedModelAllocationRoutingTable routingState;
        private Long startTime;
        private Integer timeoutCount;

        public final Builder averageInferenceTimeMs(double value) {
            this.averageInferenceTimeMs = value;
            return this;
        }

        public final Builder errorCount(int value) {
            this.errorCount = value;
            return this;
        }

        public final Builder inferenceCount(int value) {
            this.inferenceCount = value;
            return this;
        }

        public final Builder inferenceThreads(int value) {
            this.inferenceThreads = value;
            return this;
        }

        public final Builder lastAccess(long value) {
            this.lastAccess = value;
            return this;
        }

        public final Builder modelThreads(int value) {
            this.modelThreads = value;
            return this;
        }

        public final Builder node(DiscoveryNode value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<DiscoveryNode.Builder, ObjectBuilder<DiscoveryNode>> fn) {
            return this.node(fn.apply(new DiscoveryNode.Builder()).build());
        }

        public final Builder numberOfPendingRequests(int value) {
            this.numberOfPendingRequests = value;
            return this;
        }

        public final Builder rejectionExecutionCount(int value) {
            this.rejectionExecutionCount = value;
            return this;
        }

        public final Builder routingState(TrainedModelAllocationRoutingTable value) {
            this.routingState = value;
            return this;
        }

        public final Builder routingState(Function<TrainedModelAllocationRoutingTable.Builder, ObjectBuilder<TrainedModelAllocationRoutingTable>> fn) {
            return this.routingState(fn.apply(new TrainedModelAllocationRoutingTable.Builder()).build());
        }

        public final Builder startTime(long value) {
            this.startTime = value;
            return this;
        }

        public final Builder timeoutCount(int value) {
            this.timeoutCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelDeploymentNodesStats build() {
            this._checkSingleUse();
            return new TrainedModelDeploymentNodesStats(this);
        }
    }
}

