/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelInferenceStats
implements JsonpSerializable {
    private final int cacheMissCount;
    private final int failureCount;
    private final int inferenceCount;
    private final int missingAllFieldsCount;
    private final Time timestamp;
    public static final JsonpDeserializer<TrainedModelInferenceStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelInferenceStats::setupTrainedModelInferenceStatsDeserializer);

    private TrainedModelInferenceStats(Builder builder) {
        this.cacheMissCount = ApiTypeHelper.requireNonNull(builder.cacheMissCount, this, "cacheMissCount");
        this.failureCount = ApiTypeHelper.requireNonNull(builder.failureCount, this, "failureCount");
        this.inferenceCount = ApiTypeHelper.requireNonNull(builder.inferenceCount, this, "inferenceCount");
        this.missingAllFieldsCount = ApiTypeHelper.requireNonNull(builder.missingAllFieldsCount, this, "missingAllFieldsCount");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static TrainedModelInferenceStats of(Function<Builder, ObjectBuilder<TrainedModelInferenceStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int cacheMissCount() {
        return this.cacheMissCount;
    }

    public final int failureCount() {
        return this.failureCount;
    }

    public final int inferenceCount() {
        return this.inferenceCount;
    }

    public final int missingAllFieldsCount() {
        return this.missingAllFieldsCount;
    }

    public final Time timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cache_miss_count");
        generator.write(this.cacheMissCount);
        generator.writeKey("failure_count");
        generator.write(this.failureCount);
        generator.writeKey("inference_count");
        generator.write(this.inferenceCount);
        generator.writeKey("missing_all_fields_count");
        generator.write(this.missingAllFieldsCount);
        generator.writeKey("timestamp");
        this.timestamp.serialize(generator, mapper);
    }

    protected static void setupTrainedModelInferenceStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cacheMissCount, JsonpDeserializer.integerDeserializer(), "cache_miss_count");
        op.add(Builder::failureCount, JsonpDeserializer.integerDeserializer(), "failure_count");
        op.add(Builder::inferenceCount, JsonpDeserializer.integerDeserializer(), "inference_count");
        op.add(Builder::missingAllFieldsCount, JsonpDeserializer.integerDeserializer(), "missing_all_fields_count");
        op.add(Builder::timestamp, Time._DESERIALIZER, "timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelInferenceStats> {
        private Integer cacheMissCount;
        private Integer failureCount;
        private Integer inferenceCount;
        private Integer missingAllFieldsCount;
        private Time timestamp;

        public final Builder cacheMissCount(int value) {
            this.cacheMissCount = value;
            return this;
        }

        public final Builder failureCount(int value) {
            this.failureCount = value;
            return this;
        }

        public final Builder inferenceCount(int value) {
            this.inferenceCount = value;
            return this;
        }

        public final Builder missingAllFieldsCount(int value) {
            this.missingAllFieldsCount = value;
            return this;
        }

        public final Builder timestamp(Time value) {
            this.timestamp = value;
            return this;
        }

        public final Builder timestamp(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timestamp(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelInferenceStats build() {
            this._checkSingleUse();
            return new TrainedModelInferenceStats(this);
        }
    }
}

