/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.mget;

import co.elastic.clients.elasticsearch.core.get.GetResult;
import co.elastic.clients.elasticsearch.core.mget.MultiGetError;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

public class MultiGetResponseItem<TDocument>
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final JsonpSerializer<TDocument> tDocumentSerializer = null;

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private MultiGetResponseItem(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private MultiGetResponseItem(Builder<TDocument> builder) {
        this._kind = ApiTypeHelper.requireNonNull(((Builder)builder)._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(((Builder)builder)._value, builder, "<variant value>");
    }

    public static <TDocument> MultiGetResponseItem<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<MultiGetResponseItem<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isResult() {
        return this._kind == Kind.Result;
    }

    public GetResult<TDocument> result() {
        return (GetResult)TaggedUnionUtils.get(this, Kind.Result);
    }

    public boolean isFailure() {
        return this._kind == Kind.Failure;
    }

    public MultiGetError failure() {
        return (MultiGetError)TaggedUnionUtils.get(this, Kind.Failure);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
    }

    public static <TDocument> JsonpDeserializer<MultiGetResponseItem<TDocument>> createMultiGetResponseItemDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return new UnionDeserializer.Builder<MultiGetResponseItem, Kind, Object>(MultiGetResponseItem::new, false).addMember(Kind.Result, GetResult.createGetResultDeserializer(tDocumentDeserializer)).addMember(Kind.Failure, MultiGetError._DESERIALIZER).build();
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<MultiGetResponseItem<TDocument>> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<MultiGetResponseItem<TDocument>> result(GetResult<TDocument> v) {
            this._kind = Kind.Result;
            this._value = v;
            return this;
        }

        public ObjectBuilder<MultiGetResponseItem<TDocument>> result(Function<GetResult.Builder<TDocument>, ObjectBuilder<GetResult<TDocument>>> fn) {
            return this.result(fn.apply(new GetResult.Builder()).build());
        }

        public ObjectBuilder<MultiGetResponseItem<TDocument>> failure(MultiGetError v) {
            this._kind = Kind.Failure;
            this._value = v;
            return this;
        }

        public ObjectBuilder<MultiGetResponseItem<TDocument>> failure(Function<MultiGetError.Builder, ObjectBuilder<MultiGetError>> fn) {
            return this.failure(fn.apply(new MultiGetError.Builder()).build());
        }

        @Override
        public MultiGetResponseItem<TDocument> build() {
            this._checkSingleUse();
            return new MultiGetResponseItem(this);
        }
    }

    public static enum Kind {
        Result,
        Failure;

    }
}

