/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.InferTrainedModelDeploymentResponse;
import co.elastic.clients.elasticsearch.ml.NlpInferenceConfigUpdate;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferTrainedModelDeploymentRequest
extends RequestBase
implements JsonpSerializable {
    private final List<Map<String, String>> docs;
    @Nullable
    private final NlpInferenceConfigUpdate inferenceConfig;
    private final String modelId;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<InferTrainedModelDeploymentRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferTrainedModelDeploymentRequest::setupInferTrainedModelDeploymentRequestDeserializer);
    public static final Endpoint<InferTrainedModelDeploymentRequest, InferTrainedModelDeploymentResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<InferTrainedModelDeploymentRequest, InferTrainedModelDeploymentResponse>("es/ml.infer_trained_model_deployment", request -> "POST", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/deployment");
            buf.append("/_infer");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, InferTrainedModelDeploymentResponse._DESERIALIZER);

    private InferTrainedModelDeploymentRequest(Builder builder) {
        this.docs = ApiTypeHelper.unmodifiableRequired(builder.docs, (Object)this, "docs");
        this.inferenceConfig = builder.inferenceConfig;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.timeout = builder.timeout;
    }

    public static InferTrainedModelDeploymentRequest of(Function<Builder, ObjectBuilder<InferTrainedModelDeploymentRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Map<String, String>> docs() {
        return this.docs;
    }

    @Nullable
    public final NlpInferenceConfigUpdate inferenceConfig() {
        return this.inferenceConfig;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.docs)) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (Map<String, String> item0 : this.docs) {
                generator.writeStartObject();
                if (item0 != null) {
                    for (Map.Entry<String, String> item1 : item0.entrySet()) {
                        generator.writeKey(item1.getKey());
                        generator.write(item1.getValue());
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.inferenceConfig != null) {
            generator.writeKey("inference_config");
            this.inferenceConfig.serialize(generator, mapper);
        }
    }

    protected static void setupInferTrainedModelDeploymentRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer())), "docs");
        op.add(Builder::inferenceConfig, NlpInferenceConfigUpdate._DESERIALIZER, "inference_config");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferTrainedModelDeploymentRequest> {
        private List<Map<String, String>> docs;
        @Nullable
        private NlpInferenceConfigUpdate inferenceConfig;
        private String modelId;
        @Nullable
        private Time timeout;

        public final Builder docs(List<Map<String, String>> list) {
            this.docs = Builder._listAddAll(this.docs, list);
            return this;
        }

        public final Builder docs(Map<String, String> value, Map<String, String> ... values) {
            this.docs = Builder._listAdd(this.docs, value, values);
            return this;
        }

        public final Builder inferenceConfig(@Nullable NlpInferenceConfigUpdate value) {
            this.inferenceConfig = value;
            return this;
        }

        public final Builder inferenceConfig(Function<NlpInferenceConfigUpdate.Builder, ObjectBuilder<NlpInferenceConfigUpdate>> fn) {
            return this.inferenceConfig(fn.apply(new NlpInferenceConfigUpdate.Builder()).build());
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferTrainedModelDeploymentRequest build() {
            this._checkSingleUse();
            return new InferTrainedModelDeploymentRequest(this);
        }
    }
}

