/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.DeploymentAllocationState;
import co.elastic.clients.elasticsearch.ml.StartTrainedModelDeploymentResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class StartTrainedModelDeploymentRequest
extends RequestBase {
    @Nullable
    private final Integer inferenceThreads;
    private final String modelId;
    @Nullable
    private final Integer modelThreads;
    @Nullable
    private final Integer queueCapacity;
    @Nullable
    private final Time timeout;
    @Nullable
    private final DeploymentAllocationState waitFor;
    public static final Endpoint<StartTrainedModelDeploymentRequest, StartTrainedModelDeploymentResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<StartTrainedModelDeploymentRequest, StartTrainedModelDeploymentResponse>("es/ml.start_trained_model_deployment", request -> "POST", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/deployment");
            buf.append("/_start");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.inferenceThreads != null) {
            params.put("inference_threads", String.valueOf(request.inferenceThreads));
        }
        if (request.waitFor != null) {
            params.put("wait_for", request.waitFor.jsonValue());
        }
        if (request.modelThreads != null) {
            params.put("model_threads", String.valueOf(request.modelThreads));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (request.queueCapacity != null) {
            params.put("queue_capacity", String.valueOf(request.queueCapacity));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StartTrainedModelDeploymentResponse._DESERIALIZER);

    private StartTrainedModelDeploymentRequest(Builder builder) {
        this.inferenceThreads = builder.inferenceThreads;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.modelThreads = builder.modelThreads;
        this.queueCapacity = builder.queueCapacity;
        this.timeout = builder.timeout;
        this.waitFor = builder.waitFor;
    }

    public static StartTrainedModelDeploymentRequest of(Function<Builder, ObjectBuilder<StartTrainedModelDeploymentRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer inferenceThreads() {
        return this.inferenceThreads;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer modelThreads() {
        return this.modelThreads;
    }

    @Nullable
    public final Integer queueCapacity() {
        return this.queueCapacity;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final DeploymentAllocationState waitFor() {
        return this.waitFor;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<StartTrainedModelDeploymentRequest> {
        @Nullable
        private Integer inferenceThreads;
        private String modelId;
        @Nullable
        private Integer modelThreads;
        @Nullable
        private Integer queueCapacity;
        @Nullable
        private Time timeout;
        @Nullable
        private DeploymentAllocationState waitFor;

        public final Builder inferenceThreads(@Nullable Integer value) {
            this.inferenceThreads = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder modelThreads(@Nullable Integer value) {
            this.modelThreads = value;
            return this;
        }

        public final Builder queueCapacity(@Nullable Integer value) {
            this.queueCapacity = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitFor(@Nullable DeploymentAllocationState value) {
            this.waitFor = value;
            return this;
        }

        @Override
        public StartTrainedModelDeploymentRequest build() {
            this._checkSingleUse();
            return new StartTrainedModelDeploymentRequest(this);
        }
    }
}

