/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.sql.GetAsyncResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetAsyncRequest
extends RequestBase {
    @Nullable
    private final String delimiter;
    @Nullable
    private final String format;
    private final String id;
    @Nullable
    private final Time keepAlive;
    @Nullable
    private final Time waitForCompletionTimeout;
    public static final Endpoint<GetAsyncRequest, GetAsyncResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetAsyncRequest, GetAsyncResponse>("es/sql.get_async", request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_sql");
            buf.append("/async");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.delimiter != null) {
            params.put("delimiter", request.delimiter);
        }
        if (request.format != null) {
            params.put("format", request.format);
        }
        if (request.keepAlive != null) {
            params.put("keep_alive", request.keepAlive._toJsonString());
        }
        if (request.waitForCompletionTimeout != null) {
            params.put("wait_for_completion_timeout", request.waitForCompletionTimeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetAsyncResponse._DESERIALIZER);

    private GetAsyncRequest(Builder builder) {
        this.delimiter = builder.delimiter;
        this.format = builder.format;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.keepAlive = builder.keepAlive;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
    }

    public static GetAsyncRequest of(Function<Builder, ObjectBuilder<GetAsyncRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String delimiter() {
        return this.delimiter;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public final Time waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetAsyncRequest> {
        @Nullable
        private String delimiter;
        @Nullable
        private String format;
        private String id;
        @Nullable
        private Time keepAlive;
        @Nullable
        private Time waitForCompletionTimeout;

        public final Builder delimiter(@Nullable String value) {
            this.delimiter = value;
            return this;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder keepAlive(@Nullable Time value) {
            this.keepAlive = value;
            return this;
        }

        public final Builder keepAlive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.keepAlive(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitForCompletionTimeout(@Nullable Time value) {
            this.waitForCompletionTimeout = value;
            return this;
        }

        public final Builder waitForCompletionTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.waitForCompletionTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public GetAsyncRequest build() {
            this._checkSingleUse();
            return new GetAsyncRequest(this);
        }
    }
}

