/*
 * Decompiled with CFR 0.152.
 */
package co.omise;

import co.omise.Config;
import co.omise.Configurer;
import co.omise.Endpoint;
import co.omise.resources.AccountResource;
import co.omise.resources.BalanceResource;
import co.omise.resources.ChargeResource;
import co.omise.resources.ChargeSpecificResource;
import co.omise.resources.CustomerResource;
import co.omise.resources.CustomerSpecificResource;
import co.omise.resources.DisputeResource;
import co.omise.resources.EventResource;
import co.omise.resources.RecipientResource;
import co.omise.resources.TokenResource;
import co.omise.resources.TransactionResource;
import co.omise.resources.TransferResource;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import okhttp3.CertificatePinner;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class Client {
    private final Config config;
    private final OkHttpClient httpClient;
    private final AccountResource account;
    private final BalanceResource balance;
    private final ChargeResource charges;
    private final CustomerResource customers;
    private final DisputeResource disputes;
    private final EventResource events;
    private final RecipientResource recipients;
    private final TokenResource tokens;
    private final TransactionResource transactions;
    private final TransferResource transfers;

    public Client(String secretKey) {
        this(null, null, secretKey);
    }

    public Client(String publicKey, String secretKey) {
        this(null, publicKey, secretKey);
    }

    public Client(String apiVersion, String publicKey, String secretKey) {
        Preconditions.checkNotNull((Object)secretKey);
        this.config = new Config(apiVersion, publicKey, secretKey);
        this.httpClient = this.buildHttpClient(this.config);
        this.account = new AccountResource(this.httpClient);
        this.balance = new BalanceResource(this.httpClient);
        this.charges = new ChargeResource(this.httpClient);
        this.customers = new CustomerResource(this.httpClient);
        this.disputes = new DisputeResource(this.httpClient);
        this.events = new EventResource(this.httpClient);
        this.recipients = new RecipientResource(this.httpClient);
        this.tokens = new TokenResource(this.httpClient);
        this.transactions = new TransactionResource(this.httpClient);
        this.transfers = new TransferResource(this.httpClient);
    }

    protected OkHttpClient buildHttpClient(Config config) {
        CertificatePinner.Builder pinner = new CertificatePinner.Builder();
        for (Endpoint endpoint : Endpoint.all()) {
            pinner = pinner.add(endpoint.host(), new String[]{endpoint.certificateHash()});
        }
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new Configurer(config)).readTimeout(60L, TimeUnit.SECONDS).certificatePinner(pinner.build()).build();
    }

    protected OkHttpClient httpClient() {
        return this.httpClient;
    }

    public AccountResource account() {
        return this.account;
    }

    public BalanceResource balance() {
        return this.balance;
    }

    public ChargeResource charges() {
        return this.charges;
    }

    public ChargeSpecificResource charge(String chargeId) {
        return new ChargeSpecificResource(this.httpClient, chargeId);
    }

    public CustomerResource customers() {
        return this.customers;
    }

    public CustomerSpecificResource customer(String customerId) {
        return this.customers.withId(customerId);
    }

    public DisputeResource disputes() {
        return this.disputes;
    }

    public EventResource events() {
        return this.events;
    }

    public RecipientResource recipients() {
        return this.recipients;
    }

    public TokenResource tokens() {
        return this.tokens;
    }

    public TransactionResource transactions() {
        return this.transactions;
    }

    public TransferResource transfers() {
        return this.transfers;
    }
}

