/*
 * Decompiled with CFR 0.152.
 */
package co.omise;

import co.omise.Config;
import co.omise.Endpoint;
import com.google.common.base.Preconditions;
import java.io.IOException;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class Configurer
implements Interceptor {
    private final Config config;

    Configurer(Config config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
    }

    public static Request configure(Config config, Request request) {
        String apiVersion = config.apiVersion();
        String key = null;
        for (Endpoint endpoint : Endpoint.all()) {
            if (!request.url().host().equals(endpoint.host())) continue;
            key = endpoint.authenticationKey(config);
            break;
        }
        Request.Builder builder = request.newBuilder().addHeader("User-Agent", config.userAgent()).addHeader("Authorization", Credentials.basic(key, (String)"x"));
        if (apiVersion != null && !apiVersion.isEmpty()) {
            builder = builder.addHeader("Omise-Version", apiVersion);
        }
        return builder.build();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return chain.proceed(Configurer.configure(this.config, chain.request()));
    }
}

