/*
 * Decompiled with CFR 0.152.
 */
package co.omise;

import co.omise.models.OmiseObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Serializer {
    private static Serializer defaultInstance;
    private final ObjectMapper objectMapper;
    private final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeNoMillis();

    public static Serializer defaultSerializer() {
        if (defaultInstance == null) {
            defaultInstance = new Serializer();
        }
        return defaultInstance;
    }

    private Serializer() {
        this.objectMapper = new ObjectMapper();
        JodaModule joda = new JodaModule();
        joda.addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer().withFormat(new JacksonJodaDateFormat(this.dateTimeFormatter)));
        this.objectMapper.registerModule((Module)new GuavaModule());
        this.objectMapper.registerModule((Module)joda);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.objectMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public DateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public <T extends OmiseObject> T deserialize(InputStream input, Class<T> klass) throws IOException {
        return (T)((OmiseObject)this.objectMapper.readerFor(klass).readValue(input));
    }

    public <T extends OmiseObject> T deserialize(InputStream input, TypeReference<T> ref) throws IOException {
        return (T)((OmiseObject)this.objectMapper.readerFor(ref).readValue(input));
    }

    public <T extends OmiseObject> T deserializeFromMap(Map<String, Object> map, Class<T> klass) {
        return (T)((OmiseObject)this.objectMapper.convertValue(map, klass));
    }

    public <T extends OmiseObject> T deserializeFromMap(Map<String, Object> map, TypeReference<T> ref) {
        return (T)((OmiseObject)this.objectMapper.convertValue(map, ref));
    }

    public <T extends OmiseObject> void serialize(OutputStream output, T model) throws IOException {
        this.objectMapper.writerFor(model.getClass()).writeValue(output, model);
    }

    public <T extends OmiseObject> Map<String, Object> serializeToMap(T model) {
        return (Map)this.objectMapper.convertValue(model, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

