/*
 * Decompiled with CFR 0.152.
 */
package co.omise.models;

import co.omise.models.BankAccount;
import co.omise.models.Model;
import co.omise.models.Params;
import co.omise.models.RecipientType;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Recipient
extends Model {
    private boolean verified;
    private boolean active;
    private String name;
    private String email;
    private String description;
    private RecipientType type;
    @JsonProperty(value="tax_id")
    private String taxId;
    @JsonProperty(value="bank_account")
    private BankAccount bankAccount;
    @JsonProperty(value="failure_code")
    private String failureCode;

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RecipientType getType() {
        return this.type;
    }

    public void setType(RecipientType type) {
        this.type = type;
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getFailureCode() {
        return this.failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public static class RecipientParams
    extends Params {
        private BankAccount.BankAccountParams bankAccount;

        public RecipientParams name(String name) {
            this.add("name", name);
            return this;
        }

        public RecipientParams email(String email) {
            this.add("email", email);
            return this;
        }

        public RecipientParams description(String description) {
            this.add("description", description);
            return this;
        }

        public RecipientParams type(RecipientType type) {
            this.add("type", type.name().toLowerCase());
            return this;
        }

        public RecipientParams taxId(String taxId) {
            this.add("tax_id", taxId);
            return this;
        }

        public RecipientParams bankAccount(BankAccount.BankAccountParams bankAccount) {
            if (bankAccount != null) {
                bankAccount.addTo(this);
            }
            return this;
        }
    }

    public static class Update
    extends RecipientParams {
    }

    public static class Create
    extends RecipientParams {
    }
}

