/*
 * Decompiled with CFR 0.152.
 */
package co.omise.models;

import co.omise.Serializer;
import co.omise.models.Model;
import co.omise.models.OmiseObjectBase;
import co.omise.models.Ordering;
import co.omise.models.Params;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import okhttp3.RequestBody;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public class ScopedList<T extends Model>
extends OmiseObjectBase {
    private DateTime from;
    private DateTime to;
    private int offset;
    private int limit;
    private int total;
    private Ordering order;
    private ImmutableList<T> data;

    public DateTime getFrom() {
        return this.from;
    }

    public void setFrom(DateTime from) {
        this.from = from;
    }

    public DateTime getTo() {
        return this.to;
    }

    public void setTo(DateTime to) {
        this.to = to;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public Ordering getOrder() {
        return this.order;
    }

    public void setOrder(Ordering order) {
        this.order = order;
    }

    public ImmutableList<T> getData() {
        return this.data;
    }

    public void setData(ImmutableList<T> data) {
        this.data = data;
    }

    public static class Options
    extends Params {
        private Integer offset;
        private Integer limit;
        private DateTime from;
        private DateTime to;
        private Ordering order;

        public Options offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Options limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Options from(DateTime from) {
            this.from = from;
            return this;
        }

        public Options to(DateTime to) {
            this.to = to;
            return this;
        }

        public Options order(Ordering order) {
            this.order = order;
            return this;
        }

        @Override
        public ImmutableMap<String, String> query() {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            DateTimeFormatter formatter = Serializer.defaultSerializer().dateTimeFormatter();
            if (this.offset != null) {
                builder = builder.put((Object)"offset", (Object)this.offset.toString());
            }
            if (this.limit != null) {
                builder = builder.put((Object)"limit", (Object)this.limit.toString());
            }
            if (this.from != null) {
                builder = builder.put((Object)"from", (Object)formatter.print((ReadableInstant)this.from));
            }
            if (this.to != null) {
                builder = builder.put((Object)"to", (Object)formatter.print((ReadableInstant)this.to));
            }
            if (this.order != null) {
                switch (this.order) {
                    case Chronological: {
                        builder = builder.put((Object)"order", (Object)"chronological");
                        break;
                    }
                    case ReverseChronological: {
                        builder = builder.put((Object)"order", (Object)"reverse_chronological");
                    }
                }
            }
            return builder.build();
        }

        @Override
        public RequestBody body() {
            return null;
        }
    }
}

