/*
 * Decompiled with CFR 0.152.
 */
package co.omise.resources;

import co.omise.Endpoint;
import co.omise.models.Card;
import co.omise.models.ScopedList;
import co.omise.resources.Resource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class CardResource
extends Resource {
    private final String customerId;

    public CardResource(OkHttpClient httpClient, String customerId) {
        super(httpClient);
        this.customerId = customerId;
    }

    public ScopedList<Card> list() throws IOException {
        return this.list(new ScopedList.Options());
    }

    public ScopedList<Card> list(ScopedList.Options options) throws IOException {
        return this.httpGet(this.urlFor("")).params(options).returns(new TypeReference<ScopedList<Card>>(){});
    }

    public Card get(String cardId) throws IOException {
        return this.httpGet(this.urlFor(cardId)).returns(Card.class);
    }

    public Card update(String cardId, Card.Update update) throws IOException {
        return this.httpPatch(this.urlFor(cardId)).params(update).returns(Card.class);
    }

    public Card destroy(String cardId) throws IOException {
        return this.httpDelete(this.urlFor(cardId)).returns(Card.class);
    }

    private HttpUrl urlFor(String cardId) {
        return this.buildUrl(Endpoint.API, "customers", this.customerId, "cards", cardId);
    }
}

