/*
 * Decompiled with CFR 0.152.
 */
package co.omise.resources;

import co.omise.Endpoint;
import co.omise.models.Charge;
import co.omise.models.ScopedList;
import co.omise.resources.Resource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class ChargeResource
extends Resource {
    public ChargeResource(OkHttpClient httpClient) {
        super(httpClient);
    }

    public ScopedList<Charge> list() throws IOException {
        return this.list(new ScopedList.Options());
    }

    public ScopedList<Charge> list(ScopedList.Options options) throws IOException {
        return this.httpGet(this.urlFor("")).params(options).returns(new TypeReference<ScopedList<Charge>>(){});
    }

    public Charge get(String chargeId) throws IOException {
        return this.httpGet(this.urlFor(chargeId)).returns(Charge.class);
    }

    public Charge create(Charge.Create params) throws IOException {
        return this.httpPost(this.urlFor("")).params(params).returns(Charge.class);
    }

    public Charge update(String chargeId, Charge.Update params) throws IOException {
        return this.httpPatch(this.urlFor(chargeId)).params(params).returns(Charge.class);
    }

    private HttpUrl urlFor(String chargeId) {
        return this.buildUrl(Endpoint.API, "charges", chargeId);
    }
}

