/*
 * Decompiled with CFR 0.152.
 */
package co.omise.resources;

import co.omise.Endpoint;
import co.omise.models.Customer;
import co.omise.models.ScopedList;
import co.omise.resources.CustomerSpecificResource;
import co.omise.resources.Resource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class CustomerResource
extends Resource {
    public CustomerResource(OkHttpClient httpClient) {
        super(httpClient);
    }

    public CustomerSpecificResource withId(String customerId) {
        return new CustomerSpecificResource(this.httpClient(), customerId);
    }

    public ScopedList<Customer> list() throws IOException {
        return this.list(new ScopedList.Options());
    }

    public ScopedList<Customer> list(ScopedList.Options options) throws IOException {
        return this.httpGet(this.urlFor("")).params(options).returns(new TypeReference<ScopedList<Customer>>(){});
    }

    public Customer get(String customerId) throws IOException {
        return this.httpGet(this.urlFor(customerId)).returns(Customer.class);
    }

    public Customer create(Customer.CustomerParams params) throws IOException {
        return this.httpPost(this.urlFor("")).params(params).returns(Customer.class);
    }

    public Customer update(String customerId, Customer.CustomerParams params) throws IOException {
        return this.httpPatch(this.urlFor(customerId)).params(params).returns(Customer.class);
    }

    public Customer destroy(String customerId) throws IOException {
        return this.httpDelete(this.urlFor(customerId)).returns(Customer.class);
    }

    private HttpUrl urlFor(String customerId) {
        return this.buildUrl(Endpoint.API, "customers", customerId);
    }
}

