/*
 * Decompiled with CFR 0.152.
 */
package co.omise.resources;

import co.omise.Endpoint;
import co.omise.models.Dispute;
import co.omise.models.DisputeStatus;
import co.omise.models.ScopedList;
import co.omise.resources.Resource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class DisputeResource
extends Resource {
    public DisputeResource(OkHttpClient httpClient) {
        super(httpClient);
    }

    public ScopedList<Dispute> list() throws IOException {
        return this.list(null, new ScopedList.Options());
    }

    public ScopedList<Dispute> list(ScopedList.Options options) throws IOException {
        return this.list(null, options);
    }

    public ScopedList<Dispute> list(DisputeStatus status) throws IOException {
        return this.list(status, new ScopedList.Options());
    }

    public ScopedList<Dispute> list(DisputeStatus status, ScopedList.Options options) throws IOException {
        String path = status == null ? "" : status.name().toLowerCase();
        return this.httpGet(this.urlFor(path)).params(options).returns(new TypeReference<ScopedList<Dispute>>(){});
    }

    public Dispute get(String disputeId) throws IOException {
        return this.httpGet(this.urlFor(disputeId)).returns(Dispute.class);
    }

    public Dispute update(String disputeId, Dispute.Update params) throws IOException {
        return this.httpPatch(this.urlFor(disputeId)).params(params).returns(Dispute.class);
    }

    private HttpUrl urlFor(String disputeId) {
        return this.buildUrl(Endpoint.API, "disputes", disputeId);
    }
}

