/*
 * Decompiled with CFR 0.152.
 */
package co.omise.resources;

import co.omise.Endpoint;
import co.omise.models.Recipient;
import co.omise.models.ScopedList;
import co.omise.resources.Resource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class RecipientResource
extends Resource {
    public RecipientResource(OkHttpClient httpClient) {
        super(httpClient);
    }

    public ScopedList<Recipient> list() throws IOException {
        return this.list(new ScopedList.Options());
    }

    public ScopedList<Recipient> list(ScopedList.Options options) throws IOException {
        return this.httpGet(this.urlFor("")).params(options).returns(new TypeReference<ScopedList<Recipient>>(){});
    }

    public Recipient get(String recipientId) throws IOException {
        return this.httpGet(this.urlFor(recipientId)).returns(Recipient.class);
    }

    public Recipient create(Recipient.RecipientParams params) throws IOException {
        return this.httpPost(this.urlFor("")).params(params).returns(Recipient.class);
    }

    public Recipient update(String recipientId, Recipient.RecipientParams params) throws IOException {
        return this.httpPatch(this.urlFor(recipientId)).params(params).returns(Recipient.class);
    }

    public Recipient destroy(String recipientId) throws IOException {
        return this.httpDelete(this.urlFor(recipientId)).returns(Recipient.class);
    }

    private HttpUrl urlFor(String recipientId) {
        return this.buildUrl(Endpoint.API, "recipients", recipientId);
    }
}

