/*
 * Decompiled with CFR 0.152.
 */
package co.omise.resources;

import co.omise.Endpoint;
import co.omise.models.Refund;
import co.omise.models.ScopedList;
import co.omise.resources.Resource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class RefundResource
extends Resource {
    private final String chargeId;

    protected RefundResource(OkHttpClient httpClient, String chargeId) {
        super(httpClient);
        this.chargeId = chargeId;
    }

    public ScopedList<Refund> list() throws IOException {
        return this.list(new ScopedList.Options());
    }

    public ScopedList<Refund> list(ScopedList.Options options) throws IOException {
        return this.httpGet(this.urlFor("")).params(options).returns(new TypeReference<ScopedList<Refund>>(){});
    }

    public Refund get(String refundId) throws IOException {
        return this.httpGet(this.urlFor(refundId)).returns(Refund.class);
    }

    public Refund create(Refund.Create params) throws IOException {
        return this.httpPost(this.urlFor("")).params(params).returns(Refund.class);
    }

    private HttpUrl urlFor(String refundId) {
        return this.buildUrl(Endpoint.API, "charges", this.chargeId, "refunds", refundId);
    }
}

