/*
 * Decompiled with CFR 0.152.
 */
package co.omise.resources;

import co.omise.Endpoint;
import co.omise.Serializer;
import co.omise.models.OmiseError;
import co.omise.models.OmiseObject;
import co.omise.models.Params;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public abstract class Resource {
    private final OkHttpClient httpClient;
    private final Serializer serializer = Serializer.defaultSerializer();

    protected Resource(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected OkHttpClient httpClient() {
        return this.httpClient;
    }

    protected Operation httpGet(HttpUrl httpUrl) {
        return this.httpOp("GET", httpUrl);
    }

    protected Operation httpPost(HttpUrl httpUrl) {
        return this.httpOp("POST", httpUrl);
    }

    protected Operation httpPatch(HttpUrl httpUrl) {
        return this.httpOp("PATCH", httpUrl);
    }

    protected Operation httpDelete(HttpUrl httpUrl) {
        return this.httpOp("DELETE", httpUrl);
    }

    protected Operation httpOp(String method, HttpUrl url) {
        return new Operation().method(method).httpUrl(url);
    }

    protected HttpUrl buildUrl(Endpoint endpoint, String path, String ... segments) {
        Preconditions.checkNotNull((Object)endpoint);
        Preconditions.checkNotNull((Object)path);
        HttpUrl.Builder builder = endpoint.buildUrl().addPathSegment(path);
        for (String segment : segments) {
            if (segment == null || segment.isEmpty()) continue;
            builder = builder.addPathSegment(segment);
        }
        return builder.build();
    }

    protected final class Operation {
        private String method;
        private HttpUrl httpUrl;
        private Params params;

        protected Operation() {
        }

        protected Operation method(String method) {
            Preconditions.checkNotNull((Object)method);
            this.method = method;
            return this;
        }

        public Operation httpUrl(HttpUrl httpUrl) {
            this.httpUrl = httpUrl;
            return this;
        }

        public Operation params(Params params) {
            this.params = params;
            return this;
        }

        public <T extends OmiseObject> T returns(Class<T> klass) throws IOException {
            Response response = this.roundtrip();
            ResponseBody body = response.body();
            if (body == null) {
                return null;
            }
            InputStream stream = body.byteStream();
            if (200 < response.code() || response.code() >= 300) {
                throw Resource.this.serializer.deserialize(stream, OmiseError.class);
            }
            return Resource.this.serializer.deserialize(stream, klass);
        }

        public <T extends OmiseObject> T returns(TypeReference<T> typeRef) throws IOException {
            Response response = this.roundtrip();
            ResponseBody body = response.body();
            if (body == null) {
                return null;
            }
            InputStream stream = body.byteStream();
            if (200 < response.code() || response.code() >= 300) {
                throw Resource.this.serializer.deserialize(stream, OmiseError.class);
            }
            return Resource.this.serializer.deserialize(stream, typeRef);
        }

        private Response roundtrip() throws IOException {
            RequestBody body = null;
            HttpUrl.Builder urlBuilder = this.httpUrl.newBuilder();
            if (this.params != null) {
                ImmutableMap<String, String> queries = this.params.query();
                if (queries != null && !queries.isEmpty()) {
                    for (Map.Entry pair : queries.entrySet()) {
                        urlBuilder = urlBuilder.addQueryParameter((String)pair.getKey(), (String)pair.getValue());
                    }
                }
                body = this.params.body();
            }
            Request request = new Request.Builder().method(this.method, body).url(urlBuilder.build()).build();
            return Resource.this.httpClient.newCall(request).execute();
        }
    }
}

