/*
 * Decompiled with CFR 0.152.
 */
package co.omise.resources;

import co.omise.Endpoint;
import co.omise.models.ScopedList;
import co.omise.models.Transfer;
import co.omise.resources.Resource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class TransferResource
extends Resource {
    public TransferResource(OkHttpClient httpClient) {
        super(httpClient);
    }

    public ScopedList<Transfer> list() throws IOException {
        return this.list(new ScopedList.Options());
    }

    public ScopedList<Transfer> list(ScopedList.Options options) throws IOException {
        return this.httpGet(this.urlFor("")).params(options).returns(new TypeReference<ScopedList<Transfer>>(){});
    }

    public Transfer get(String transferId) throws IOException {
        return this.httpGet(this.urlFor(transferId)).returns(Transfer.class);
    }

    public Transfer create(Transfer.Create params) throws IOException {
        return this.httpPost(this.urlFor("")).params(params).returns(Transfer.class);
    }

    public Transfer update(String transferId, Transfer.Update params) throws IOException {
        return this.httpPatch(this.urlFor(transferId)).params(params).returns(Transfer.class);
    }

    public Transfer destroy(String transferId) throws IOException {
        return this.httpDelete(this.urlFor(transferId)).returns(Transfer.class);
    }

    private HttpUrl urlFor(String transferId) {
        return this.buildUrl(Endpoint.API, "transfers", transferId);
    }
}

