/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.hibernate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.apache.beehive.controls.api.bean.ControlImplementation;
import org.apache.beehive.controls.api.context.Context;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.api.context.ResourceContext;
import org.apache.beehive.controls.api.events.EventHandler;
import org.apache.log4j.Logger;
import org.controlhaus.hibernate.HibernateControl;
import org.controlhaus.hibernate.HibernateFactory;

@ControlImplementation
public class HibernateControlImpl
implements HibernateControl {
    private static Logger logger = Logger.getLogger((String)HibernateControlImpl.class.getName());
    private ThreadLocal<Session> session = new ThreadLocal();
    private List<Session> sessions = new ArrayList<Session>();
    private SessionFactory sessionFactory;
    private Configuration hibConfig;
    private String location = "/hibernate.cfg.xml";
    private String instance = "default";
    @Context
    ControlBeanContext context;
    @Context
    ResourceContext resourceContext;

    public HibernateControlImpl() {
        String propLoc = System.getProperty("hibernate.cfg.xml");
        if (propLoc != null) {
            this.location = propLoc;
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Configuration getConfiguration() {
        return this.hibConfig;
    }

    public String getConfigurationLocation() {
        return this.location;
    }

    public String getHibernateInstance() {
        return this.instance;
    }

    @EventHandler(field="resourceContext", eventSet=ResourceContext.ResourceEvents.class, eventName="onAcquire")
    public void onAcquire() {
        HibernateControl.HibernateInstance iProp = (HibernateControl.HibernateInstance)this.context.getControlPropertySet(HibernateControl.HibernateInstance.class);
        if (this.instance != null) {
            this.instance = iProp.value();
        }
        this.sessionFactory = HibernateFactory.getInstance().getSessionFactory(this);
    }

    @EventHandler(field="resourceContext", eventSet=ResourceContext.ResourceEvents.class, eventName="onRelease")
    public void onRelease() {
        Iterator<Session> itr = this.sessions.iterator();
        while (itr.hasNext()) {
            Session s = itr.next();
            try {
                logger.debug((Object)"Closing open hibernate session.");
                s.close();
                itr.remove();
            }
            catch (HibernateException e) {
                logger.error((Object)"Couldn't close session!", (Throwable)e);
            }
        }
    }

    public Session getSession() throws HibernateException {
        Session s = this.session.get();
        if (s == null) {
            s = this.sessionFactory.openSession();
            this.session.set(s);
            this.sessions.add(s);
        }
        return s;
    }

    public void closeSession() throws HibernateException {
        logger.info((Object)"Closing session for thread.");
        Session s = this.session.get();
        if (s != null) {
            this.sessions.remove(s);
            this.session.set(null);
            s.close();
        }
    }
}

