/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.hibernate.util;

import java.lang.reflect.Method;
import java.sql.Connection;
import junit.framework.TestCase;
import net.sf.hibernate.Session;
import org.apache.beehive.controls.api.bean.Control;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.runtime.bean.ControlContainerContext;
import org.controlhaus.hibernate.HibernateControl;
import org.controlhaus.hibernate.util.BatchSqlCommandRunner;

public class AbstractHibernateTest
extends TestCase {
    public static final String SETUP_SQL = "hibernate.setupSql";
    public static final String TEARDOWN_SQL = "hibernate.teardownSql";
    private ControlContainerContext context;
    private Connection conn;
    @Control
    HibernateControl hibernate;

    public void setUp() throws Exception {
        super.setUp();
        this.context = new ControlContainerContext();
        for (Class<?> top = ((Object)((Object)this)).getClass(); top != null; top = top.getSuperclass()) {
            this.initializeClass(top);
        }
        String filename = System.getProperty(SETUP_SQL);
        if (filename != null) {
            try {
                this.insertSqlFile(filename);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void initializeClass(Class clazz) throws Exception {
        try {
            Class<?> init = ((Object)((Object)this)).getClass().getClassLoader().loadClass(clazz.getName() + "ClientInitializer");
            Method m = init.getMethod("initialize", ControlBeanContext.class, clazz);
            m.invoke(null, new Object[]{this.context, this});
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void insertSqlFile(String filename) throws Exception {
        if (this.hibernate == null) {
            throw new RuntimeException("AbstractHibernateTest was not initialized!");
        }
        Session sess = this.hibernate.getSessionFactory().openSession();
        this.conn = sess.connection();
        System.out.println("Loading SQL " + filename);
        BatchSqlCommandRunner runner = new BatchSqlCommandRunner(this.conn);
        runner.runCommands(filename);
        sess.close();
    }

    public void tearDown() throws Exception {
        String filename = System.getProperty(TEARDOWN_SQL);
        if (filename != null) {
            try {
                this.insertSqlFile(filename);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.conn = null;
        super.tearDown();
    }

    public ControlContainerContext getContext() {
        return this.context;
    }
}

