/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.hibernate.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class BatchSqlCommandRunner {
    private StringBuffer _buf = new StringBuffer();
    private Statement _stmt = null;

    public BatchSqlCommandRunner(Statement stmt) {
        this._stmt = stmt;
    }

    public BatchSqlCommandRunner(Connection conn) throws SQLException {
        this(conn.createStatement());
    }

    public void close() {
        try {
            this._stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String readLine(BufferedReader reader) throws IOException {
        String result = reader.readLine();
        if (result != null) {
            result.trim();
        }
        return result;
    }

    protected String readCommand(BufferedReader reader) throws IOException {
        this._buf.setLength(0);
        String line = null;
        boolean done = false;
        boolean inQuote = false;
        while (!done && (line = this.readLine(reader)) != null) {
            if (line.indexOf("/*") != -1 || line.indexOf("#") != -1 || line.indexOf("--") != -1) continue;
            this._buf.append(line);
            this._buf.append(' ');
            inQuote = this.isInQuotes(line, inQuote);
            done = !inQuote && line.trim().endsWith(";");
        }
        return this._buf.toString().trim();
    }

    protected boolean isInQuotes(String line, boolean inQuotes) {
        boolean result = inQuotes;
        int quotePos = -1;
        int startPos = 0;
        while ((quotePos = line.indexOf("'", startPos)) > -1) {
            result = !result;
            startPos = quotePos + 1;
        }
        return result;
    }

    public void runCommands(String resourceLoc) throws IOException, SQLException {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream in = loader.getResourceAsStream(resourceLoc);
        if (in == null) {
            in = new FileInputStream(resourceLoc);
        }
        if (in == null) {
            System.out.println("Could not find resource " + resourceLoc + " in classpath");
        } else {
            this.runCommands(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommands(InputStream in) throws IOException, SQLException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            this.runCommands(reader);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommands(BufferedReader reader) throws IOException, SQLException {
        try {
            String cmd = null;
            while (!(cmd = this.readCommand(reader)).equals("")) {
                System.out.println("executing cmd " + cmd);
                this._stmt.execute(cmd);
            }
        }
        finally {
            reader.close();
        }
    }
}

