package cool.scx.ext.cms;

import cool.scx.BaseModule;
import cool.scx.ScxTemplate;

/**
 * cms 模块 提供一些简单的 指令
 *
 * @author scx567888
 * @version 1.1.11
 */
public class CMSModule implements BaseModule {

    private final CMSModuleConfiguration cmsModuleConfiguration;

    /**
     * <p>Constructor for CmsModule.</p>
     */
    public CMSModule() {
        cmsModuleConfiguration = new CMSModuleConfiguration();
    }

    /**
     * <p>Constructor for CmsModule.</p>
     *
     * @param configuration a {@link java.lang.Class} object
     */
    public CMSModule(CMSModuleConfiguration configuration) {
        cmsModuleConfiguration = configuration;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void start() {
        //添加默认指令和用户指令到 模板指令中
        for (var aClass : this.cmsModuleConfiguration.defaultDirective()) {
            ScxTemplate.addDirective(aClass);
        }
        for (var aClass : this.cmsModuleConfiguration.getUserDirective()) {
            ScxTemplate.addDirective(aClass);
        }
    }

    /**
     * @return
     */
    public CMSModuleConfiguration getCmsModuleConfiguration() {
        return cmsModuleConfiguration;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String name() {
        return "SCX-CMSModule";
    }

}
