package cool.scx.ext.fss;

import cool.scx.ScxConfig;
import cool.scx.util.Ansi;
import cool.scx.util.FileUtils;

import java.io.File;

/**
 * 核心模块配置文件
 *
 * @author scx567888
 * @version 1.1.2
 */
public class FSSConfig {

    private static FSSEasyToUse FSSEasyToUse;

    /**
     * <p>initConfig.</p>
     */
    protected static void initConfig() {
        FSSEasyToUse = new FSSEasyToUse();
    }

    /**
     * <p>uploadFilePath.</p>
     *
     * @return a {@link java.io.File} object.
     */
    public static File uploadFilePath() {
        return FSSEasyToUse.uploadFilePath;
    }

    private static String formatFileSize(String s) {
        return FileUtils.longToDisplaySize(FileUtils.displaySizeToLong(s));
    }

    static class FSSEasyToUse {

        /**
         * 文件上传路径
         */
        final File uploadFilePath;

        FSSEasyToUse() {

            var tempUploadFilePath = ScxConfig.get("fss.physical-file-path", "AppRoot:/FSS_FILES/",
                    s -> Ansi.out().magenta("Y FSS 物理文件存储位置                   \t -->\t " + FileUtils.getFileByAppRoot(s)).println(),
                    f -> Ansi.out().red("N 未检测到 fss.physical-file-path  \t -->\t 已采用默认值 : " + FileUtils.getFileByAppRoot(f)).println());

            uploadFilePath = FileUtils.getFileByAppRoot(tempUploadFilePath);

        }
    }

}
