package cool.scx.ext.organization;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.bo.Where;
import cool.scx.enumeration.WhereType;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * RoleService
 *
 * @author scx567888
 * @version 1.1.2
 */
@ScxService
public class RoleService extends BaseService<Role> {

    private final UserRoleService userRoleService;

    /**
     * <p>Constructor for CoreRoleService.</p>
     *
     * @param userRoleService a {@link cool.scx.ext.organization.UserRoleService} object.
     */
    public RoleService(UserRoleService userRoleService) {
        this.userRoleService = userRoleService;
    }

    /**
     * getRoleListByUser
     *
     * @param user a {@link cool.scx.ext.organization.User} object
     * @return a {@link java.util.List} object
     */
    public List<Role> getRoleListByUser(User user) {
        try {
            var roleIds = userRoleService.list(new Query().equal("userId", user.id))
                    .stream().map(userRole -> userRole.roleId).collect(Collectors.toList());
            return list(new Query().in("id", roleIds));
        } catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return new ArrayList<>();
        }
    }

    /**
     * getUserRoleByUserIds
     *
     * @param userIds a {@link cool.scx.ext.organization.User} object
     * @return a {@link java.util.List} object
     */
    public List<UserRole> getUserRoleByUserIds(List<Long> userIds) {
        try {
            return userRoleService.list(new Query().in("userId", userIds));
        } catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return new ArrayList<>();
        }
    }


    /**
     * saveRoleListWithUserId
     *
     * @param userId  a {@link java.lang.Long} object
     * @param roleIds a {@link java.lang.String} object
     * @throws SQLException s
     */
    public void saveRoleListWithUserId(Long userId, List<Long> roleIds) throws SQLException {
        if (roleIds != null) {
            var idArr = roleIds.stream().filter(Objects::nonNull).map(id -> {
                        var userRole = new UserRole();
                        userRole.userId = userId;
                        userRole.roleId = id;
                        return userRole;
                    }
            ).collect(Collectors.toList());
            userRoleService.save(idArr);
        }
    }

    /**
     * {@inheritDoc}
     *
     * @param id a {@link java.lang.Long} object
     * @throws SQLException s
     */
    public void deleteByUserId(Long id) throws SQLException {
        var where = new Where("userId", WhereType.EQUAL, id);
        userRoleService.delete(where);
    }

}
