/**
 * Copyright (c) 2021-2031 murenchao
 * fig is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.software.fig.entity;

import java.io.Serializable;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@SuppressWarnings("all")
public class FigData<T extends Object> implements Serializable {
  private String command;
  
  private String topic;
  
  private long tiem = System.currentTimeMillis();
  
  private T data;
  
  @Pure
  public String getCommand() {
    return this.command;
  }
  
  public void setCommand(final String command) {
    this.command = command;
  }
  
  @Pure
  public String getTopic() {
    return this.topic;
  }
  
  public void setTopic(final String topic) {
    this.topic = topic;
  }
  
  @Pure
  public long getTiem() {
    return this.tiem;
  }
  
  public void setTiem(final long tiem) {
    this.tiem = tiem;
  }
  
  @Pure
  public T getData() {
    return this.data;
  }
  
  public void setData(final T data) {
    this.data = data;
  }
}
