/*
 * The file is generated from /home/honza/git/proxima/proxima-platform/beam/core-testing/src/main/resources/test-readme.conf.
 * DO NOT EDIT! YOUR CHANGES WILL BE OVERWRITTEN.
 */

package cz.o2.proxima.testing.model;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.AttributeFamilyDescriptor;
import cz.o2.proxima.repository.ConfigRepository;
import cz.o2.proxima.repository.DataOperator;
import cz.o2.proxima.repository.EntityAwareAttributeDescriptor;
import cz.o2.proxima.repository.EntityAwareAttributeDescriptor.Regular;
import cz.o2.proxima.repository.EntityAwareAttributeDescriptor.Wildcard;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.repository.RepositoryFactory;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

/* operator specific imports */

public class Model implements Serializable {

  private static final String GENERATED_FROM = " entities {\n"
 + "   # user entity, let's make this really simple\n"
 + "   user {\n"
 + "     attributes {\n"
 + "\n"
 + "       # some details of user - e.g. name, email, ...\n"
 + "       details { scheme: \"proto:cz.o2.proxima.example.Example.UserDetails\" }\n"
 + "\n"
 + "       # model of preferences based on events\n"
 + "       preferences { scheme: \"proto:cz.o2.proxima.example.Example.UserPreferences\" }\n"
 + "\n"
 + "       # selected events are stored to user's history\n"
 + "       \"event.*\" { scheme: \"proto:cz.o2.proxima.example.Example.BaseEvent\" }\n"
 + "\n"
 + "     }\n"
 + "   }\n"
 + "   # entity describing a single good we want to sell\n"
 + "   product {\n"
 + "     # note: we have to split to separate attributes each attribute that we want to be able\n"
 + "     # to update *independently*\n"
 + "     attributes {\n"
 + "\n"
 + "       # price, with some possible additional information, like VAT and other stuff\n"
 + "       price { scheme: \"proto:cz.o2.proxima.example.Example.Price\" }\n"
 + "\n"
 + "       # some general details of the product\n"
 + "       details { scheme: \"proto:cz.o2.proxima.example.Example.ProductDetails\" }\n"
 + "\n"
 + "       # list of associated categories\n"
 + "       \"category.*\" { scheme: \"proto:cz.o2.proxima.example.Example.ProductCategory\" }\n"
 + "\n"
 + "     }\n"
 + "   }\n"
 + "\n"
 + "   # the events which link users to goods\n"
 + "   event {\n"
 + "     attributes {\n"
 + "\n"
 + "       # the event is atomic entity with just a single attribute\n"
 + "       data { scheme: \"proto:cz.o2.proxima.example.Example.BaseEvent\" }\n"
 + "\n"
 + "     }\n"
 + "   }\n"
 + "\n"
 + " }\n"
 + "\n"
 + " attributeFamilies {\n"
 + "\n"
 + "    # we need this to be able to read user attributes 'details' and 'preferences' by user's key\n"
 + "    user-random-access {\n"
 + "      entity: user\n"
 + "      attributes: [ \"details\", \"preferences\" ]\n"
 + "      storage: \"cassandra://\"${cassandra.seed}/${cassandra.user-table}\"?primary=user\"\n"
 + "      type: primary\n"
 + "      access: random-access\n"
 + "    }\n"
 + "\n"
 + "    # store incoming events to user's history\n"
 + "    user-event-history-store {\n"
 + "      entity: event\n"
 + "      attributes: [ \"data\" ]\n"
 + "      storage: \"cassandra://\"${cassandra.seed}/${cassandra.user-event-table}/\n"
 + "      # this class defines how we transform incoming event to CQL\n"
 + "      cqlFactory: cz.o2.proxima.example.EventHistoryCqlFactory\n"
 + "      # this is filtering condition, we want to select only some events\n"
 + "      filter: cz.o2.proxima.example.EventHistoryFilter\n"
 + "      type: replica\n"
 + "      access: write-only\n"
 + "    }\n"
 + "\n"
 + "    # this family defines read access to the stored event history\n"
 + "    user-event-history-read {\n"
 + "      entity: user\n"
 + "      attributes: [ \"event.*\" ]\n"
 + "      storage: \"cassandra://\"${cassandra.seed}/${cassandra.user-event-table}\"?primary=user&secondary=stamp&data=event&reversed=true\"\n"
 + "      # ignore this for now\n"
 + "      converter: cz.o2.proxima.storage.cassandra.DateToLongConverter\n"
 + "      type: replica\n"
 + "      # we will not explicitly modify this, it will be updated automatically by incoming events\n"
 + "      access: read-only\n"
 + "    }\n"
 + "\n"
 + "    # random access to products\n"
 + "    product-random-acesss {\n"
 + "      entity: product\n"
 + "      attributes: [ \"*\" ]\n"
 + "      storage: \"cassandra://\"${cassandra.seed}/${cassandra.product-table}\n"
 + "      type: primary\n"
 + "      access: random-access\n"
 + "    }\n"
 + "\n"
 + "    # event stream storage\n"
 + "    event-commit-log {\n"
 + "      entity: event\n"
 + "      attributes: [ \"*\" ]\n"
 + "      storage: \"kafka://\"${kafka.brokers}/${kafka.events-topic}\n"
 + "      # this is our commit log\n"
 + "      type: primary\n"
 + "      access: commit-log\n"
 + "    }\n"
 + "\n"
 + "    # store events for batch analytics\n"
 + "    event-batch-storage {\n"
 + "      entity: event\n"
 + "      attributes: [ \"*\" ]\n"
 + "      storage: \"hdfs://\"${hdfs.authority}/${hdfs.event-path}\n"
 + "      type: replica\n"
 + "      access: batch-updates\n"
 + "    }\n"
 + "\n"
 + "  }\n"
 + "\n"
 + "  cassandra {\n"
 + "    seed = \"cassandra:9042\"\n"
 + "    user-table = \"user\"\n"
 + "    product-table = \"product\"\n"
 + "    user-event-table = \"user_event\"\n"
 + "  }\n"
 + "\n"
 + "  kafka {\n"
 + "    brokers = \"kafka1:9092,kafka2:9092,kafka3:9092\"\n"
 + "    events-topic = \"events\"\n"
 + "  }\n"
 + "\n"
 + "  hdfs {\n"
 + "    authority = \"hdfs-master\"\n"
 + "    event-path = \"/events\"\n"
 + "  }\n"
 + "\n";

  /**
   * Create instance of {@code Model} for production usage.
   *
   * @param cfg configuration to use
   * @return Model
   **/
  public static Model of(Config cfg) {
    return new Model(ConfigRepository.Builder.of(
        cfg.withFallback(ConfigFactory.parseString(GENERATED_FROM))));
  }

  /**
   * Create instance of {@code Model} with specified {@code ConfigRepository.Builder}.
   *
   * @param builder configuration to use
   * @return Model
   **/
  public static Model of(ConfigRepository.Builder builder) {
    return new Model(builder);
  }

  /**
   * Create instance of {@code Model} for testing purposes.
   *
   * @param config the configuration to use
   * @param validations which validations to perform
   * @return Model
   **/
  public static Model ofTest(Config config, Repository.Validate... validations) {
    return new Model(
        ConfigRepository.Builder
            .ofTest(config.withFallback(ConfigFactory.parseString(GENERATED_FROM)))
            .withValidate(validations));
  }

  @FunctionalInterface
  static interface EntityDescriptorProvider {
    EntityDescriptor getDescriptor();
  }

  @FunctionalInterface
  static interface DataOperatorProvider<T extends DataOperator> extends Serializable {

    T getOperator();

  }



  /**
   * Class wrapping access to attribute data of entity product.
   **/
  public class ProductWrapper implements Serializable {

    private cz.o2.proxima.example.Example.Price Price = null;
    @SuppressWarnings("unchecked")
    private final cz.o2.proxima.example.Example.Price PriceDefault = (cz.o2.proxima.example.Example.Price)
      factory.apply().getEntity("product").getAttribute("price").getValueSerializer().getDefault();
      private cz.o2.proxima.example.Example.ProductDetails Details = null;
    @SuppressWarnings("unchecked")
    private final cz.o2.proxima.example.Example.ProductDetails DetailsDefault = (cz.o2.proxima.example.Example.ProductDetails)
      factory.apply().getEntity("product").getAttribute("details").getValueSerializer().getDefault();
     

    private ProductWrapper() {

    }

    public cz.o2.proxima.example.Example.Price getPrice() {
      return Price == null ? PriceDefault : Price;
    }
        public cz.o2.proxima.example.Example.ProductDetails getDetails() {
      return Details == null ? DetailsDefault : Details;
    }
         

  }

  /**
   * Class wrapping views on entity product
   **/
  public class Product implements Serializable, EntityDescriptorProvider {

    private final EntityDescriptor descriptor = factory.apply().getEntity("product");

    @Override
    public EntityDescriptor getDescriptor() {
      return descriptor;
    }

    private final Regular<cz.o2.proxima.example.Example.Price> priceDescriptor =
      EntityAwareAttributeDescriptor.regular(descriptor, descriptor.getAttribute("price"));
    public Regular<cz.o2.proxima.example.Example.Price> getPriceDescriptor() {
      return priceDescriptor;
    }
     
      private final Regular<cz.o2.proxima.example.Example.ProductDetails> detailsDescriptor =
      EntityAwareAttributeDescriptor.regular(descriptor, descriptor.getAttribute("details"));
    public Regular<cz.o2.proxima.example.Example.ProductDetails> getDetailsDescriptor() {
      return detailsDescriptor;
    }
     
      private final Wildcard<cz.o2.proxima.example.Example.ProductCategory> categoryDescriptor =
      EntityAwareAttributeDescriptor.wildcard(descriptor, descriptor.getAttribute("category.*"));
    public Wildcard<cz.o2.proxima.example.Example.ProductCategory> getCategoryDescriptor() {
      return categoryDescriptor;
    }
 
   

    private Product() { }

  }



  /**
   * Class wrapping access to attribute data of entity event.
   **/
  public class EventWrapper implements Serializable {

    private cz.o2.proxima.example.Example.BaseEvent Data = null;
    @SuppressWarnings("unchecked")
    private final cz.o2.proxima.example.Example.BaseEvent DataDefault = (cz.o2.proxima.example.Example.BaseEvent)
      factory.apply().getEntity("event").getAttribute("data").getValueSerializer().getDefault();
   

    private EventWrapper() {

    }

    public cz.o2.proxima.example.Example.BaseEvent getData() {
      return Data == null ? DataDefault : Data;
    }
     

  }

  /**
   * Class wrapping views on entity event
   **/
  public class Event implements Serializable, EntityDescriptorProvider {

    private final EntityDescriptor descriptor = factory.apply().getEntity("event");

    @Override
    public EntityDescriptor getDescriptor() {
      return descriptor;
    }

    private final Regular<cz.o2.proxima.example.Example.BaseEvent> dataDescriptor =
      EntityAwareAttributeDescriptor.regular(descriptor, descriptor.getAttribute("data"));
    public Regular<cz.o2.proxima.example.Example.BaseEvent> getDataDescriptor() {
      return dataDescriptor;
    }
     
   

    private Event() { }

  }



  /**
   * Class wrapping access to attribute data of entity user.
   **/
  public class UserWrapper implements Serializable {

    private cz.o2.proxima.example.Example.UserPreferences Preferences = null;
    @SuppressWarnings("unchecked")
    private final cz.o2.proxima.example.Example.UserPreferences PreferencesDefault = (cz.o2.proxima.example.Example.UserPreferences)
      factory.apply().getEntity("user").getAttribute("preferences").getValueSerializer().getDefault();
        private cz.o2.proxima.example.Example.UserDetails Details = null;
    @SuppressWarnings("unchecked")
    private final cz.o2.proxima.example.Example.UserDetails DetailsDefault = (cz.o2.proxima.example.Example.UserDetails)
      factory.apply().getEntity("user").getAttribute("details").getValueSerializer().getDefault();
   

    private UserWrapper() {

    }

    public cz.o2.proxima.example.Example.UserPreferences getPreferences() {
      return Preferences == null ? PreferencesDefault : Preferences;
    }
            public cz.o2.proxima.example.Example.UserDetails getDetails() {
      return Details == null ? DetailsDefault : Details;
    }
     

  }

  /**
   * Class wrapping views on entity user
   **/
  public class User implements Serializable, EntityDescriptorProvider {

    private final EntityDescriptor descriptor = factory.apply().getEntity("user");

    @Override
    public EntityDescriptor getDescriptor() {
      return descriptor;
    }

    private final Regular<cz.o2.proxima.example.Example.UserPreferences> preferencesDescriptor =
      EntityAwareAttributeDescriptor.regular(descriptor, descriptor.getAttribute("preferences"));
    public Regular<cz.o2.proxima.example.Example.UserPreferences> getPreferencesDescriptor() {
      return preferencesDescriptor;
    }
     
      private final Wildcard<cz.o2.proxima.example.Example.BaseEvent> eventDescriptor =
      EntityAwareAttributeDescriptor.wildcard(descriptor, descriptor.getAttribute("event.*"));
    public Wildcard<cz.o2.proxima.example.Example.BaseEvent> getEventDescriptor() {
      return eventDescriptor;
    }
 
      private final Regular<cz.o2.proxima.example.Example.UserDetails> detailsDescriptor =
      EntityAwareAttributeDescriptor.regular(descriptor, descriptor.getAttribute("details"));
    public Regular<cz.o2.proxima.example.Example.UserDetails> getDetailsDescriptor() {
      return detailsDescriptor;
    }
     
   

    private User() { }

  }



  private final Config cfg;
  private final RepositoryFactory factory;

  private final Product product;
  private final Event event;
  private final User user;


  private Model(ConfigRepository.Builder builder) {
    this.factory = Objects.requireNonNull(builder).build().asFactory();
    Repository repo = this.factory.apply();
    this.cfg = ((ConfigRepository) repo).getConfig();
    product = new Product();
    event = new Event();
    user = new User();
  }

  public Product getProduct() {
    return product;
  }
  public Event getEvent() {
    return event;
  }
  public User getUser() {
    return user;
  }

  public Repository getRepo() {
    return factory.apply();
  }

}

