/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.api.complextypes;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.dfs.connection.api.complextypes.BucketDirectory;
import de.adorsys.dfs.connection.api.complextypes.BucketPath;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketPathUtil {
    private static final String WINDOWS_BUCKET_PATH_SEPARATOR = "\\\\";
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketPathUtil.class);

    public static String getAsString(BucketDirectory bucketDirectory) {
        String container = bucketDirectory.getObjectHandle().getContainer();
        String name = bucketDirectory.getObjectHandle().getName();
        if (name == null) {
            name = "";
        }
        return container + "/" + name;
    }

    public static String getAsString(BucketPath bucketPath) {
        String container = bucketPath.getObjectHandle().getContainer();
        String name = bucketPath.getObjectHandle().getName();
        if (name == null) {
            name = "";
        }
        return container + "/" + name;
    }

    public static void checkContainerName(String name) {
        if (name.indexOf("/") != -1) {
            throw new BaseException(name + " is not a valid container name. Must not contain " + "/");
        }
    }

    public static List<String> split(String fullBucketPath) {
        ArrayList<String> list = new ArrayList<String>();
        if (fullBucketPath == null) {
            return list;
        }
        fullBucketPath = fullBucketPath.replaceAll(WINDOWS_BUCKET_PATH_SEPARATOR, "/");
        StringTokenizer st = new StringTokenizer(fullBucketPath, "/");
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if (!BucketPathUtil.notOnlyWhitespace(token)) continue;
            list.add(token);
        }
        return list;
    }

    private static boolean notOnlyWhitespace(String value) {
        return value.replaceAll(" ", "").length() > 0;
    }
}

