/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.dfs.connection.api.domain;

import de.adorsys.dfs.connection.api.exceptions.BucketRestrictionException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;

@ApiModel(value="ObjectHandle", description="Contains information necessary to storage or retrieval an object from the object storage.")
public class ObjectHandle {
    private String container;
    private String name;

    public ObjectHandle() {
    }

    public ObjectHandle(String container, String name) {
        ObjectHandle.checkRestrictions(container);
        this.container = container;
        this.name = name;
    }

    @ApiModelProperty(value="The name of the container in which the object is stored")
    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        ObjectHandle.checkRestrictions(container);
        this.container = container;
    }

    @ApiModelProperty(value="The name of the object in the store")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static void checkRestrictions(String container) {
        if (container == null) {
            throw new BucketRestrictionException("Bucket must not be null");
        }
        if (container.length() < 3 && File.separator.equals("/")) {
            throw new BucketRestrictionException("Bucket length must be at least 3 chars: " + container);
        }
        if (!container.toLowerCase().equals(container)) {
            throw new BucketRestrictionException("Bucket must not contain uppercase letters: " + container);
        }
    }
}

