/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.elasticsearch2.utils;

import de.bytefish.elasticutils.elasticsearch2.mapping.IElasticSearchMapping;
import de.bytefish.elasticutils.exceptions.CreateIndexFailedException;
import de.bytefish.elasticutils.exceptions.IndicesExistsFailedException;
import de.bytefish.elasticutils.exceptions.PutMappingFailedException;
import java.io.IOException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;

public class ElasticSearchUtils {
    private static final ESLogger log = ESLoggerFactory.getLogger((String)ElasticSearchUtils.class.getName());

    private ElasticSearchUtils() {
    }

    public static IndicesExistsResponse indexExist(Client client, String indexName) {
        try {
            return (IndicesExistsResponse)client.admin().indices().prepareExists(new String[]{indexName}).execute().actionGet();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Checking Index Exist", (Throwable)e, new Object[0]);
            }
            throw new IndicesExistsFailedException(indexName, (Throwable)e);
        }
    }

    public static CreateIndexResponse createIndex(Client client, String indexName) {
        try {
            return ElasticSearchUtils.internalCreateIndex(client, indexName);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Creating Index", (Throwable)e, new Object[0]);
            }
            throw new CreateIndexFailedException(indexName, (Throwable)e);
        }
    }

    public static PutMappingResponse putMapping(Client client, String indexName, IElasticSearchMapping mapping) {
        try {
            return ElasticSearchUtils.internalPutMapping(client, indexName, mapping);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Creating Index", (Throwable)e, new Object[0]);
            }
            throw new PutMappingFailedException(indexName, (Throwable)e);
        }
    }

    private static CreateIndexResponse internalCreateIndex(Client client, String indexName) throws IOException {
        CreateIndexRequestBuilder createIndexRequestBuilder = client.admin().indices().prepareCreate(indexName);
        CreateIndexResponse indexResponse = (CreateIndexResponse)createIndexRequestBuilder.execute().actionGet();
        if (log.isDebugEnabled()) {
            log.debug("CreatedIndexResponse: isAcknowledged {}", new Object[]{indexResponse.isAcknowledged()});
        }
        return indexResponse;
    }

    private static PutMappingResponse internalPutMapping(Client client, String indexName, IElasticSearchMapping mapping) throws IOException {
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{indexName}).type(mapping.getIndexType()).source(mapping.getMapping().string());
        PutMappingResponse putMappingResponse = (PutMappingResponse)client.admin().indices().putMapping(putMappingRequest).actionGet();
        if (log.isDebugEnabled()) {
            log.debug("PutMappingResponse: isAcknowledged {}", new Object[]{putMappingResponse.isAcknowledged()});
        }
        return putMappingResponse;
    }
}

