/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.elasticsearch2.mapping;

import com.google.common.collect.ImmutableMap;
import de.bytefish.elasticutils.elasticsearch2.mapping.IElasticSearchMapping;
import de.bytefish.elasticutils.exceptions.GetMappingFailedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public abstract class BaseElasticSearchMapping
implements IElasticSearchMapping {
    private final String indexType;
    private final Version version;

    public BaseElasticSearchMapping(String indexType, Version version) {
        this.indexType = indexType;
        this.version = version;
    }

    @Override
    public XContentBuilder getMapping() {
        try {
            return this.internalGetMapping();
        }
        catch (Exception e) {
            throw new GetMappingFailedException(this.indexType, (Throwable)e);
        }
    }

    @Override
    public String getIndexType() {
        return this.indexType;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public XContentBuilder internalGetMapping() throws IOException {
        RootObjectMapper.Builder rootObjectMapperBuilder = this.getRootObjectBuilder();
        Settings.Builder settingsBuilder = this.getSettingsBuilder();
        Mapping mapping = new Mapping(this.version, (RootObjectMapper)rootObjectMapperBuilder.build(new Mapper.BuilderContext(settingsBuilder.build(), new ContentPath())), this.getMetaDataFieldMappers(), this.getSourceTransforms(), this.getMetaData());
        return mapping.toXContent(JsonXContent.contentBuilder().startObject(), ToXContent.EMPTY_PARAMS);
    }

    private RootObjectMapper.Builder getRootObjectBuilder() {
        RootObjectMapper.Builder rootObjectMapperBuilder = new RootObjectMapper.Builder(this.indexType);
        this.configureRootObjectBuilder(rootObjectMapperBuilder);
        return rootObjectMapperBuilder;
    }

    private Settings.Builder getSettingsBuilder() {
        Settings.Builder settingsBuilder = Settings.builder().put("index.version.created", this.version).put("index.creation_date", System.currentTimeMillis());
        this.configureSettingsBuilder(settingsBuilder);
        return settingsBuilder;
    }

    private MetadataFieldMapper[] getMetaDataFieldMappers() {
        ArrayList<MetadataFieldMapper> metadataFieldMapper = new ArrayList<MetadataFieldMapper>();
        this.configureMetaDataFieldMappers(metadataFieldMapper);
        return metadataFieldMapper.toArray(new MetadataFieldMapper[metadataFieldMapper.size()]);
    }

    protected Mapping.SourceTransform[] getSourceTransforms() {
        ArrayList<Mapping.SourceTransform> sourceTransforms = new ArrayList<Mapping.SourceTransform>();
        this.configureSourceTransforms(sourceTransforms);
        return sourceTransforms.toArray(new Mapping.SourceTransform[sourceTransforms.size()]);
    }

    private ImmutableMap<String, Object> getMetaData() {
        ImmutableMap.Builder metaDataBuilder = new ImmutableMap.Builder();
        this.configureMetaDataBuilder((ImmutableMap.Builder<String, Object>)metaDataBuilder);
        return metaDataBuilder.build();
    }

    protected abstract void configureRootObjectBuilder(RootObjectMapper.Builder var1);

    protected void configureSettingsBuilder(Settings.Builder builder) {
    }

    protected void configureMetaDataFieldMappers(List<MetadataFieldMapper> metadataFieldMapper) {
    }

    protected void configureSourceTransforms(List<Mapping.SourceTransform> sourceTransforms) {
    }

    protected void configureMetaDataBuilder(ImmutableMap.Builder<String, Object> metaDataBuilder) {
    }
}

